/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerSoftwareInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerSoftwareInfo> {
    private static final SdkField<String> CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BrokerSoftwareInfo.getter(BrokerSoftwareInfo::configurationArn)).setter(BrokerSoftwareInfo.setter(Builder::configurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationArn").build()}).build();
    private static final SdkField<Long> CONFIGURATION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BrokerSoftwareInfo.getter(BrokerSoftwareInfo::configurationRevision)).setter(BrokerSoftwareInfo.setter(Builder::configurationRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationRevision").build()}).build();
    private static final SdkField<String> KAFKA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BrokerSoftwareInfo.getter(BrokerSoftwareInfo::kafkaVersion)).setter(BrokerSoftwareInfo.setter(Builder::kafkaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ARN_FIELD, CONFIGURATION_REVISION_FIELD, KAFKA_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationArn;
    private final Long configurationRevision;
    private final String kafkaVersion;

    private BrokerSoftwareInfo(BuilderImpl builder) {
        this.configurationArn = builder.configurationArn;
        this.configurationRevision = builder.configurationRevision;
        this.kafkaVersion = builder.kafkaVersion;
    }

    public String configurationArn() {
        return this.configurationArn;
    }

    public Long configurationRevision() {
        return this.configurationRevision;
    }

    public String kafkaVersion() {
        return this.kafkaVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerSoftwareInfo)) {
            return false;
        }
        BrokerSoftwareInfo other = (BrokerSoftwareInfo)obj;
        return Objects.equals(this.configurationArn(), other.configurationArn()) && Objects.equals(this.configurationRevision(), other.configurationRevision()) && Objects.equals(this.kafkaVersion(), other.kafkaVersion());
    }

    public String toString() {
        return ToString.builder((String)"BrokerSoftwareInfo").add("ConfigurationArn", (Object)this.configurationArn()).add("ConfigurationRevision", (Object)this.configurationRevision()).add("KafkaVersion", (Object)this.kafkaVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.configurationArn()));
            }
            case "ConfigurationRevision": {
                return Optional.ofNullable(clazz.cast(this.configurationRevision()));
            }
            case "KafkaVersion": {
                return Optional.ofNullable(clazz.cast(this.kafkaVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerSoftwareInfo, T> g) {
        return obj -> g.apply((BrokerSoftwareInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationArn;
        private Long configurationRevision;
        private String kafkaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerSoftwareInfo model) {
            this.configurationArn(model.configurationArn);
            this.configurationRevision(model.configurationRevision);
            this.kafkaVersion(model.kafkaVersion);
        }

        public final String getConfigurationArn() {
            return this.configurationArn;
        }

        @Override
        public final Builder configurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
            return this;
        }

        public final void setConfigurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
        }

        public final Long getConfigurationRevision() {
            return this.configurationRevision;
        }

        @Override
        public final Builder configurationRevision(Long configurationRevision) {
            this.configurationRevision = configurationRevision;
            return this;
        }

        public final void setConfigurationRevision(Long configurationRevision) {
            this.configurationRevision = configurationRevision;
        }

        public final String getKafkaVersion() {
            return this.kafkaVersion;
        }

        @Override
        public final Builder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        public final void setKafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
        }

        public BrokerSoftwareInfo build() {
            return new BrokerSoftwareInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerSoftwareInfo> {
        public Builder configurationArn(String var1);

        public Builder configurationRevision(Long var1);

        public Builder kafkaVersion(String var1);
    }
}

