/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode;
import software.amazon.awssdk.services.ivsrealtime.model.EventName;
import software.amazon.awssdk.services.ivsrealtime.model.ExchangedParticipantToken;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Event.getter(Event::nameAsString)).setter(Event.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(Event.getter(Event::participantId)).setter(Event.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(Event.getter(Event::eventTime)).setter(Event.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> REMOTE_PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteParticipantId").getter(Event.getter(Event::remoteParticipantId)).setter(Event.setter(Builder::remoteParticipantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteParticipantId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(Event.getter(Event::errorCodeAsString)).setter(Event.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> DESTINATION_STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationStageArn").getter(Event.getter(Event::destinationStageArn)).setter(Event.setter(Builder::destinationStageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationStageArn").build()}).build();
    private static final SdkField<String> DESTINATION_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationSessionId").getter(Event.getter(Event::destinationSessionId)).setter(Event.setter(Builder::destinationSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSessionId").build()}).build();
    private static final SdkField<Boolean> REPLICA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("replica").getter(Event.getter(Event::replica)).setter(Event.setter(Builder::replica)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replica").build()}).build();
    private static final SdkField<ExchangedParticipantToken> PREVIOUS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("previousToken").getter(Event.getter(Event::previousToken)).setter(Event.setter(Builder::previousToken)).constructor(ExchangedParticipantToken::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousToken").build()}).build();
    private static final SdkField<ExchangedParticipantToken> NEW_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newToken").getter(Event.getter(Event::newToken)).setter(Event.setter(Builder::newToken)).constructor(ExchangedParticipantToken::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PARTICIPANT_ID_FIELD, EVENT_TIME_FIELD, REMOTE_PARTICIPANT_ID_FIELD, ERROR_CODE_FIELD, DESTINATION_STAGE_ARN_FIELD, DESTINATION_SESSION_ID_FIELD, REPLICA_FIELD, PREVIOUS_TOKEN_FIELD, NEW_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Event.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String participantId;
    private final Instant eventTime;
    private final String remoteParticipantId;
    private final String errorCode;
    private final String destinationStageArn;
    private final String destinationSessionId;
    private final Boolean replica;
    private final ExchangedParticipantToken previousToken;
    private final ExchangedParticipantToken newToken;

    private Event(BuilderImpl builder) {
        this.name = builder.name;
        this.participantId = builder.participantId;
        this.eventTime = builder.eventTime;
        this.remoteParticipantId = builder.remoteParticipantId;
        this.errorCode = builder.errorCode;
        this.destinationStageArn = builder.destinationStageArn;
        this.destinationSessionId = builder.destinationSessionId;
        this.replica = builder.replica;
        this.previousToken = builder.previousToken;
        this.newToken = builder.newToken;
    }

    public final EventName name() {
        return EventName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String remoteParticipantId() {
        return this.remoteParticipantId;
    }

    public final EventErrorCode errorCode() {
        return EventErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String destinationStageArn() {
        return this.destinationStageArn;
    }

    public final String destinationSessionId() {
        return this.destinationSessionId;
    }

    public final Boolean replica() {
        return this.replica;
    }

    public final ExchangedParticipantToken previousToken() {
        return this.previousToken;
    }

    public final ExchangedParticipantToken newToken() {
        return this.newToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteParticipantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replica());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.newToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.remoteParticipantId(), other.remoteParticipantId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.destinationStageArn(), other.destinationStageArn()) && Objects.equals(this.destinationSessionId(), other.destinationSessionId()) && Objects.equals(this.replica(), other.replica()) && Objects.equals(this.previousToken(), other.previousToken()) && Objects.equals(this.newToken(), other.newToken());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("Name", (Object)this.nameAsString()).add("ParticipantId", (Object)this.participantId()).add("EventTime", (Object)this.eventTime()).add("RemoteParticipantId", (Object)this.remoteParticipantId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("DestinationStageArn", (Object)this.destinationStageArn()).add("DestinationSessionId", (Object)this.destinationSessionId()).add("Replica", (Object)this.replica()).add("PreviousToken", (Object)this.previousToken()).add("NewToken", (Object)this.newToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "remoteParticipantId": {
                return Optional.ofNullable(clazz.cast(this.remoteParticipantId()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "destinationStageArn": {
                return Optional.ofNullable(clazz.cast(this.destinationStageArn()));
            }
            case "destinationSessionId": {
                return Optional.ofNullable(clazz.cast(this.destinationSessionId()));
            }
            case "replica": {
                return Optional.ofNullable(clazz.cast(this.replica()));
            }
            case "previousToken": {
                return Optional.ofNullable(clazz.cast(this.previousToken()));
            }
            case "newToken": {
                return Optional.ofNullable(clazz.cast(this.newToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("eventTime", EVENT_TIME_FIELD);
        map.put("remoteParticipantId", REMOTE_PARTICIPANT_ID_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("destinationStageArn", DESTINATION_STAGE_ARN_FIELD);
        map.put("destinationSessionId", DESTINATION_SESSION_ID_FIELD);
        map.put("replica", REPLICA_FIELD);
        map.put("previousToken", PREVIOUS_TOKEN_FIELD);
        map.put("newToken", NEW_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String participantId;
        private Instant eventTime;
        private String remoteParticipantId;
        private String errorCode;
        private String destinationStageArn;
        private String destinationSessionId;
        private Boolean replica;
        private ExchangedParticipantToken previousToken;
        private ExchangedParticipantToken newToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.name(model.name);
            this.participantId(model.participantId);
            this.eventTime(model.eventTime);
            this.remoteParticipantId(model.remoteParticipantId);
            this.errorCode(model.errorCode);
            this.destinationStageArn(model.destinationStageArn);
            this.destinationSessionId(model.destinationSessionId);
            this.replica(model.replica);
            this.previousToken(model.previousToken);
            this.newToken(model.newToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(EventName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getRemoteParticipantId() {
            return this.remoteParticipantId;
        }

        public final void setRemoteParticipantId(String remoteParticipantId) {
            this.remoteParticipantId = remoteParticipantId;
        }

        @Override
        public final Builder remoteParticipantId(String remoteParticipantId) {
            this.remoteParticipantId = remoteParticipantId;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(EventErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getDestinationStageArn() {
            return this.destinationStageArn;
        }

        public final void setDestinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
        }

        @Override
        public final Builder destinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
            return this;
        }

        public final String getDestinationSessionId() {
            return this.destinationSessionId;
        }

        public final void setDestinationSessionId(String destinationSessionId) {
            this.destinationSessionId = destinationSessionId;
        }

        @Override
        public final Builder destinationSessionId(String destinationSessionId) {
            this.destinationSessionId = destinationSessionId;
            return this;
        }

        public final Boolean getReplica() {
            return this.replica;
        }

        public final void setReplica(Boolean replica) {
            this.replica = replica;
        }

        @Override
        public final Builder replica(Boolean replica) {
            this.replica = replica;
            return this;
        }

        public final ExchangedParticipantToken.Builder getPreviousToken() {
            return this.previousToken != null ? this.previousToken.toBuilder() : null;
        }

        public final void setPreviousToken(ExchangedParticipantToken.BuilderImpl previousToken) {
            this.previousToken = previousToken != null ? previousToken.build() : null;
        }

        @Override
        public final Builder previousToken(ExchangedParticipantToken previousToken) {
            this.previousToken = previousToken;
            return this;
        }

        public final ExchangedParticipantToken.Builder getNewToken() {
            return this.newToken != null ? this.newToken.toBuilder() : null;
        }

        public final void setNewToken(ExchangedParticipantToken.BuilderImpl newToken) {
            this.newToken = newToken != null ? newToken.build() : null;
        }

        @Override
        public final Builder newToken(ExchangedParticipantToken newToken) {
            this.newToken = newToken;
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder name(String var1);

        public Builder name(EventName var1);

        public Builder participantId(String var1);

        public Builder eventTime(Instant var1);

        public Builder remoteParticipantId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(EventErrorCode var1);

        public Builder destinationStageArn(String var1);

        public Builder destinationSessionId(String var1);

        public Builder replica(Boolean var1);

        public Builder previousToken(ExchangedParticipantToken var1);

        default public Builder previousToken(Consumer<ExchangedParticipantToken.Builder> previousToken) {
            return this.previousToken((ExchangedParticipantToken)((ExchangedParticipantToken.Builder)ExchangedParticipantToken.builder().applyMutation(previousToken)).build());
        }

        public Builder newToken(ExchangedParticipantToken var1);

        default public Builder newToken(Consumer<ExchangedParticipantToken.Builder> newToken) {
            return this.newToken((ExchangedParticipantToken)((ExchangedParticipantToken.Builder)ExchangedParticipantToken.builder().applyMutation(newToken)).build());
        }
    }
}

