/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.IngestConfigurationSummary;
import software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsResponse;

public class ListIngestConfigurationsPublisher
implements SdkPublisher<ListIngestConfigurationsResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListIngestConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIngestConfigurationsPublisher(IvsRealTimeAsyncClient client, ListIngestConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIngestConfigurationsPublisher(IvsRealTimeAsyncClient client, ListIngestConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIngestConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIngestConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IngestConfigurationSummary> ingestConfigurations() {
        Function<ListIngestConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingestConfigurations() != null) {
                return response.ingestConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIngestConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIngestConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListIngestConfigurationsResponse> {
        private ListIngestConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIngestConfigurationsResponse> nextPage(ListIngestConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestConfigurationsPublisher.this.client.listIngestConfigurations(ListIngestConfigurationsPublisher.this.firstRequest);
            }
            return ListIngestConfigurationsPublisher.this.client.listIngestConfigurations((ListIngestConfigurationsRequest)((Object)ListIngestConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

