/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.AutoParticipantRecordingConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenConfigurationsCopier;
import software.amazon.awssdk.services.ivsrealtime.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStageRequest
extends IvsRealTimeRequest
implements ToCopyableBuilder<Builder, CreateStageRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateStageRequest.getter(CreateStageRequest::name)).setter(CreateStageRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<ParticipantTokenConfiguration>> PARTICIPANT_TOKEN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("participantTokenConfigurations").getter(CreateStageRequest.getter(CreateStageRequest::participantTokenConfigurations)).setter(CreateStageRequest.setter(Builder::participantTokenConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantTokenConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParticipantTokenConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateStageRequest.getter(CreateStageRequest::tags)).setter(CreateStageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AutoParticipantRecordingConfiguration> AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoParticipantRecordingConfiguration").getter(CreateStageRequest.getter(CreateStageRequest::autoParticipantRecordingConfiguration)).setter(CreateStageRequest.setter(Builder::autoParticipantRecordingConfiguration)).constructor(AutoParticipantRecordingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoParticipantRecordingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PARTICIPANT_TOKEN_CONFIGURATIONS_FIELD, TAGS_FIELD, AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStageRequest.memberNameToFieldInitializer();
    private final String name;
    private final List<ParticipantTokenConfiguration> participantTokenConfigurations;
    private final Map<String, String> tags;
    private final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

    private CreateStageRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.participantTokenConfigurations = builder.participantTokenConfigurations;
        this.tags = builder.tags;
        this.autoParticipantRecordingConfiguration = builder.autoParticipantRecordingConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasParticipantTokenConfigurations() {
        return this.participantTokenConfigurations != null && !(this.participantTokenConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ParticipantTokenConfiguration> participantTokenConfigurations() {
        return this.participantTokenConfigurations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration() {
        return this.autoParticipantRecordingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParticipantTokenConfigurations() ? this.participantTokenConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoParticipantRecordingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStageRequest)) {
            return false;
        }
        CreateStageRequest other = (CreateStageRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasParticipantTokenConfigurations() == other.hasParticipantTokenConfigurations() && Objects.equals(this.participantTokenConfigurations(), other.participantTokenConfigurations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.autoParticipantRecordingConfiguration(), other.autoParticipantRecordingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStageRequest").add("Name", (Object)this.name()).add("ParticipantTokenConfigurations", this.hasParticipantTokenConfigurations() ? this.participantTokenConfigurations() : null).add("Tags", this.hasTags() ? this.tags() : null).add("AutoParticipantRecordingConfiguration", (Object)this.autoParticipantRecordingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "participantTokenConfigurations": {
                return Optional.ofNullable(clazz.cast(this.participantTokenConfigurations()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "autoParticipantRecordingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoParticipantRecordingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("participantTokenConfigurations", PARTICIPANT_TOKEN_CONFIGURATIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("autoParticipantRecordingConfiguration", AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStageRequest, T> g) {
        return obj -> g.apply((CreateStageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<ParticipantTokenConfiguration> participantTokenConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStageRequest model) {
            super(model);
            this.name(model.name);
            this.participantTokenConfigurations(model.participantTokenConfigurations);
            this.tags(model.tags);
            this.autoParticipantRecordingConfiguration(model.autoParticipantRecordingConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ParticipantTokenConfiguration.Builder> getParticipantTokenConfigurations() {
            List<ParticipantTokenConfiguration.Builder> result = ParticipantTokenConfigurationsCopier.copyToBuilder(this.participantTokenConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParticipantTokenConfigurations(Collection<ParticipantTokenConfiguration.BuilderImpl> participantTokenConfigurations) {
            this.participantTokenConfigurations = ParticipantTokenConfigurationsCopier.copyFromBuilder(participantTokenConfigurations);
        }

        @Override
        public final Builder participantTokenConfigurations(Collection<ParticipantTokenConfiguration> participantTokenConfigurations) {
            this.participantTokenConfigurations = ParticipantTokenConfigurationsCopier.copy(participantTokenConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokenConfigurations(ParticipantTokenConfiguration ... participantTokenConfigurations) {
            this.participantTokenConfigurations(Arrays.asList(participantTokenConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantTokenConfigurations(Consumer<ParticipantTokenConfiguration.Builder> ... participantTokenConfigurations) {
            this.participantTokenConfigurations(Stream.of(participantTokenConfigurations).map(c -> (ParticipantTokenConfiguration)((ParticipantTokenConfiguration.Builder)ParticipantTokenConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final AutoParticipantRecordingConfiguration.Builder getAutoParticipantRecordingConfiguration() {
            return this.autoParticipantRecordingConfiguration != null ? this.autoParticipantRecordingConfiguration.toBuilder() : null;
        }

        public final void setAutoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration.BuilderImpl autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration.build() : null;
        }

        @Override
        public final Builder autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStageRequest build() {
            return new CreateStageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRealTimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStageRequest> {
        public Builder name(String var1);

        public Builder participantTokenConfigurations(Collection<ParticipantTokenConfiguration> var1);

        public Builder participantTokenConfigurations(ParticipantTokenConfiguration ... var1);

        public Builder participantTokenConfigurations(Consumer<ParticipantTokenConfiguration.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration var1);

        default public Builder autoParticipantRecordingConfiguration(Consumer<AutoParticipantRecordingConfiguration.Builder> autoParticipantRecordingConfiguration) {
            return this.autoParticipantRecordingConfiguration((AutoParticipantRecordingConfiguration)((AutoParticipantRecordingConfiguration.Builder)AutoParticipantRecordingConfiguration.builder().applyMutation(autoParticipantRecordingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

