/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IngestConfigurationListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.IngestConfigurationSummary;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIngestConfigurationsResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListIngestConfigurationsResponse> {
    private static final SdkField<List<IngestConfigurationSummary>> INGEST_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ingestConfigurations").getter(ListIngestConfigurationsResponse.getter(ListIngestConfigurationsResponse::ingestConfigurations)).setter(ListIngestConfigurationsResponse.setter(Builder::ingestConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngestConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIngestConfigurationsResponse.getter(ListIngestConfigurationsResponse::nextToken)).setter(ListIngestConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGEST_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIngestConfigurationsResponse.memberNameToFieldInitializer();
    private final List<IngestConfigurationSummary> ingestConfigurations;
    private final String nextToken;

    private ListIngestConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.ingestConfigurations = builder.ingestConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIngestConfigurations() {
        return this.ingestConfigurations != null && !(this.ingestConfigurations instanceof SdkAutoConstructList);
    }

    public final List<IngestConfigurationSummary> ingestConfigurations() {
        return this.ingestConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngestConfigurations() ? this.ingestConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestConfigurationsResponse)) {
            return false;
        }
        ListIngestConfigurationsResponse other = (ListIngestConfigurationsResponse)((Object)obj);
        return this.hasIngestConfigurations() == other.hasIngestConfigurations() && Objects.equals(this.ingestConfigurations(), other.ingestConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIngestConfigurationsResponse").add("IngestConfigurations", this.hasIngestConfigurations() ? this.ingestConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ingestConfigurations": {
                return Optional.ofNullable(clazz.cast(this.ingestConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ingestConfigurations", INGEST_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngestConfigurationsResponse, T> g) {
        return obj -> g.apply((ListIngestConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private List<IngestConfigurationSummary> ingestConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestConfigurationsResponse model) {
            super(model);
            this.ingestConfigurations(model.ingestConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<IngestConfigurationSummary.Builder> getIngestConfigurations() {
            List<IngestConfigurationSummary.Builder> result = IngestConfigurationListCopier.copyToBuilder(this.ingestConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngestConfigurations(Collection<IngestConfigurationSummary.BuilderImpl> ingestConfigurations) {
            this.ingestConfigurations = IngestConfigurationListCopier.copyFromBuilder(ingestConfigurations);
        }

        @Override
        public final Builder ingestConfigurations(Collection<IngestConfigurationSummary> ingestConfigurations) {
            this.ingestConfigurations = IngestConfigurationListCopier.copy(ingestConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestConfigurations(IngestConfigurationSummary ... ingestConfigurations) {
            this.ingestConfigurations(Arrays.asList(ingestConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestConfigurations(Consumer<IngestConfigurationSummary.Builder> ... ingestConfigurations) {
            this.ingestConfigurations(Stream.of(ingestConfigurations).map(c -> (IngestConfigurationSummary)((IngestConfigurationSummary.Builder)IngestConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIngestConfigurationsResponse build() {
            return new ListIngestConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIngestConfigurationsResponse> {
        public Builder ingestConfigurations(Collection<IngestConfigurationSummary> var1);

        public Builder ingestConfigurations(IngestConfigurationSummary ... var1);

        public Builder ingestConfigurations(Consumer<IngestConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

