/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsResponse;

public class ListCompositionsPublisher
implements SdkPublisher<ListCompositionsResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListCompositionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCompositionsPublisher(IvsRealTimeAsyncClient client, ListCompositionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCompositionsPublisher(IvsRealTimeAsyncClient client, ListCompositionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCompositionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCompositionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCompositionsResponseFetcher
    implements AsyncPageFetcher<ListCompositionsResponse> {
        private ListCompositionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCompositionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCompositionsResponse> nextPage(ListCompositionsResponse previousPage) {
            if (previousPage == null) {
                return ListCompositionsPublisher.this.client.listCompositions(ListCompositionsPublisher.this.firstRequest);
            }
            return ListCompositionsPublisher.this.client.listCompositions((ListCompositionsRequest)((Object)ListCompositionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

