/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantRecordingState;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantSummary> {
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(ParticipantSummary.getter(ParticipantSummary::participantId)).setter(ParticipantSummary.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ParticipantSummary.getter(ParticipantSummary::userId)).setter(ParticipantSummary.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ParticipantSummary.getter(ParticipantSummary::stateAsString)).setter(ParticipantSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstJoinTime").getter(ParticipantSummary.getter(ParticipantSummary::firstJoinTime)).setter(ParticipantSummary.setter(Builder::firstJoinTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("published").getter(ParticipantSummary.getter(ParticipantSummary::published)).setter(ParticipantSummary.setter(Builder::published)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()}).build();
    private static final SdkField<String> RECORDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingState").getter(ParticipantSummary.getter(ParticipantSummary::recordingStateAsString)).setter(ParticipantSummary.setter(Builder::recordingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ID_FIELD, USER_ID_FIELD, STATE_FIELD, FIRST_JOIN_TIME_FIELD, PUBLISHED_FIELD, RECORDING_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("participantId", PARTICIPANT_ID_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("state", STATE_FIELD);
            this.put("firstJoinTime", FIRST_JOIN_TIME_FIELD);
            this.put("published", PUBLISHED_FIELD);
            this.put("recordingState", RECORDING_STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String participantId;
    private final String userId;
    private final String state;
    private final Instant firstJoinTime;
    private final Boolean published;
    private final String recordingState;

    private ParticipantSummary(BuilderImpl builder) {
        this.participantId = builder.participantId;
        this.userId = builder.userId;
        this.state = builder.state;
        this.firstJoinTime = builder.firstJoinTime;
        this.published = builder.published;
        this.recordingState = builder.recordingState;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String userId() {
        return this.userId;
    }

    public final ParticipantState state() {
        return ParticipantState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant firstJoinTime() {
        return this.firstJoinTime;
    }

    public final Boolean published() {
        return this.published;
    }

    public final ParticipantRecordingState recordingState() {
        return ParticipantRecordingState.fromValue(this.recordingState);
    }

    public final String recordingStateAsString() {
        return this.recordingState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.published());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantSummary)) {
            return false;
        }
        ParticipantSummary other = (ParticipantSummary)obj;
        return Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.firstJoinTime(), other.firstJoinTime()) && Objects.equals(this.published(), other.published()) && Objects.equals(this.recordingStateAsString(), other.recordingStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantSummary").add("ParticipantId", (Object)this.participantId()).add("UserId", (Object)this.userId()).add("State", (Object)this.stateAsString()).add("FirstJoinTime", (Object)this.firstJoinTime()).add("Published", (Object)this.published()).add("RecordingState", (Object)this.recordingStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "firstJoinTime": {
                return Optional.ofNullable(clazz.cast(this.firstJoinTime()));
            }
            case "published": {
                return Optional.ofNullable(clazz.cast(this.published()));
            }
            case "recordingState": {
                return Optional.ofNullable(clazz.cast(this.recordingStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ParticipantSummary, T> g) {
        return obj -> g.apply((ParticipantSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String participantId;
        private String userId;
        private String state;
        private Instant firstJoinTime;
        private Boolean published;
        private String recordingState;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantSummary model) {
            this.participantId(model.participantId);
            this.userId(model.userId);
            this.state(model.state);
            this.firstJoinTime(model.firstJoinTime);
            this.published(model.published);
            this.recordingState(model.recordingState);
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getFirstJoinTime() {
            return this.firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final Boolean getPublished() {
            return this.published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getRecordingState() {
            return this.recordingState;
        }

        public final void setRecordingState(String recordingState) {
            this.recordingState = recordingState;
        }

        @Override
        public final Builder recordingState(String recordingState) {
            this.recordingState = recordingState;
            return this;
        }

        @Override
        public final Builder recordingState(ParticipantRecordingState recordingState) {
            this.recordingState(recordingState == null ? null : recordingState.toString());
            return this;
        }

        public ParticipantSummary build() {
            return new ParticipantSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantSummary> {
        public Builder participantId(String var1);

        public Builder userId(String var1);

        public Builder state(String var1);

        public Builder state(ParticipantState var1);

        public Builder firstJoinTime(Instant var1);

        public Builder published(Boolean var1);

        public Builder recordingState(String var1);

        public Builder recordingState(ParticipantRecordingState var1);
    }
}

