/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse;

public class ListStagesPublisher
implements SdkPublisher<ListStagesResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListStagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStagesPublisher(IvsRealTimeAsyncClient client, ListStagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStagesPublisher(IvsRealTimeAsyncClient client, ListStagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStagesResponseFetcher
    implements AsyncPageFetcher<ListStagesResponse> {
        private ListStagesResponseFetcher() {
        }

        public boolean hasNextPage(ListStagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStagesResponse> nextPage(ListStagesResponse previousPage) {
            if (previousPage == null) {
                return ListStagesPublisher.this.client.listStages(ListStagesPublisher.this.firstRequest);
            }
            return ListStagesPublisher.this.client.listStages((ListStagesRequest)((Object)ListStagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

