/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.CompositionSummary;
import software.amazon.awssdk.services.ivsrealtime.model.CompositionSummaryListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCompositionsResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListCompositionsResponse> {
    private static final SdkField<List<CompositionSummary>> COMPOSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("compositions").getter(ListCompositionsResponse.getter(ListCompositionsResponse::compositions)).setter(ListCompositionsResponse.setter(Builder::compositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCompositionsResponse.getter(ListCompositionsResponse::nextToken)).setter(ListCompositionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("compositions", COMPOSITIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CompositionSummary> compositions;
    private final String nextToken;

    private ListCompositionsResponse(BuilderImpl builder) {
        super(builder);
        this.compositions = builder.compositions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCompositions() {
        return this.compositions != null && !(this.compositions instanceof SdkAutoConstructList);
    }

    public final List<CompositionSummary> compositions() {
        return this.compositions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositions() ? this.compositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompositionsResponse)) {
            return false;
        }
        ListCompositionsResponse other = (ListCompositionsResponse)((Object)obj);
        return this.hasCompositions() == other.hasCompositions() && Objects.equals(this.compositions(), other.compositions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCompositionsResponse").add("Compositions", this.hasCompositions() ? this.compositions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "compositions": {
                return Optional.ofNullable(clazz.cast(this.compositions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCompositionsResponse, T> g) {
        return obj -> g.apply((ListCompositionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private List<CompositionSummary> compositions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompositionsResponse model) {
            super(model);
            this.compositions(model.compositions);
            this.nextToken(model.nextToken);
        }

        public final List<CompositionSummary.Builder> getCompositions() {
            List<CompositionSummary.Builder> result = CompositionSummaryListCopier.copyToBuilder(this.compositions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositions(Collection<CompositionSummary.BuilderImpl> compositions) {
            this.compositions = CompositionSummaryListCopier.copyFromBuilder(compositions);
        }

        @Override
        public final Builder compositions(Collection<CompositionSummary> compositions) {
            this.compositions = CompositionSummaryListCopier.copy(compositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositions(CompositionSummary ... compositions) {
            this.compositions(Arrays.asList(compositions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositions(Consumer<CompositionSummary.Builder> ... compositions) {
            this.compositions(Stream.of(compositions).map(c -> (CompositionSummary)((CompositionSummary.Builder)CompositionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCompositionsResponse build() {
            return new ListCompositionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCompositionsResponse> {
        public Builder compositions(Collection<CompositionSummary> var1);

        public Builder compositions(CompositionSummary ... var1);

        public Builder compositions(Consumer<CompositionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

