/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantRecordingFilterByRecordingState;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListParticipantsRequest
extends IvsRealTimeRequest
implements ToCopyableBuilder<Builder, ListParticipantsRequest> {
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageArn").getter(ListParticipantsRequest.getter(ListParticipantsRequest::stageArn)).setter(ListParticipantsRequest.setter(Builder::stageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(ListParticipantsRequest.getter(ListParticipantsRequest::sessionId)).setter(ListParticipantsRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> FILTER_BY_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByUserId").getter(ListParticipantsRequest.getter(ListParticipantsRequest::filterByUserId)).setter(ListParticipantsRequest.setter(Builder::filterByUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByUserId").build()}).build();
    private static final SdkField<Boolean> FILTER_BY_PUBLISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("filterByPublished").getter(ListParticipantsRequest.getter(ListParticipantsRequest::filterByPublished)).setter(ListParticipantsRequest.setter(Builder::filterByPublished)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByPublished").build()}).build();
    private static final SdkField<String> FILTER_BY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByState").getter(ListParticipantsRequest.getter(ListParticipantsRequest::filterByStateAsString)).setter(ListParticipantsRequest.setter(Builder::filterByState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByState").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListParticipantsRequest.getter(ListParticipantsRequest::nextToken)).setter(ListParticipantsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListParticipantsRequest.getter(ListParticipantsRequest::maxResults)).setter(ListParticipantsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> FILTER_BY_RECORDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByRecordingState").getter(ListParticipantsRequest.getter(ListParticipantsRequest::filterByRecordingStateAsString)).setter(ListParticipantsRequest.setter(Builder::filterByRecordingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByRecordingState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ARN_FIELD, SESSION_ID_FIELD, FILTER_BY_USER_ID_FIELD, FILTER_BY_PUBLISHED_FIELD, FILTER_BY_STATE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_BY_RECORDING_STATE_FIELD));
    private final String stageArn;
    private final String sessionId;
    private final String filterByUserId;
    private final Boolean filterByPublished;
    private final String filterByState;
    private final String nextToken;
    private final Integer maxResults;
    private final String filterByRecordingState;

    private ListParticipantsRequest(BuilderImpl builder) {
        super(builder);
        this.stageArn = builder.stageArn;
        this.sessionId = builder.sessionId;
        this.filterByUserId = builder.filterByUserId;
        this.filterByPublished = builder.filterByPublished;
        this.filterByState = builder.filterByState;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filterByRecordingState = builder.filterByRecordingState;
    }

    public final String stageArn() {
        return this.stageArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String filterByUserId() {
        return this.filterByUserId;
    }

    public final Boolean filterByPublished() {
        return this.filterByPublished;
    }

    public final ParticipantState filterByState() {
        return ParticipantState.fromValue(this.filterByState);
    }

    public final String filterByStateAsString() {
        return this.filterByState;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ParticipantRecordingFilterByRecordingState filterByRecordingState() {
        return ParticipantRecordingFilterByRecordingState.fromValue(this.filterByRecordingState);
    }

    public final String filterByRecordingStateAsString() {
        return this.filterByRecordingState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByPublished());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByRecordingStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParticipantsRequest)) {
            return false;
        }
        ListParticipantsRequest other = (ListParticipantsRequest)((Object)obj);
        return Objects.equals(this.stageArn(), other.stageArn()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.filterByUserId(), other.filterByUserId()) && Objects.equals(this.filterByPublished(), other.filterByPublished()) && Objects.equals(this.filterByStateAsString(), other.filterByStateAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filterByRecordingStateAsString(), other.filterByRecordingStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListParticipantsRequest").add("StageArn", (Object)this.stageArn()).add("SessionId", (Object)this.sessionId()).add("FilterByUserId", (Object)this.filterByUserId()).add("FilterByPublished", (Object)this.filterByPublished()).add("FilterByState", (Object)this.filterByStateAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("FilterByRecordingState", (Object)this.filterByRecordingStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stageArn": {
                return Optional.ofNullable(clazz.cast(this.stageArn()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "filterByUserId": {
                return Optional.ofNullable(clazz.cast(this.filterByUserId()));
            }
            case "filterByPublished": {
                return Optional.ofNullable(clazz.cast(this.filterByPublished()));
            }
            case "filterByState": {
                return Optional.ofNullable(clazz.cast(this.filterByStateAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "filterByRecordingState": {
                return Optional.ofNullable(clazz.cast(this.filterByRecordingStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListParticipantsRequest, T> g) {
        return obj -> g.apply((ListParticipantsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeRequest.BuilderImpl
    implements Builder {
        private String stageArn;
        private String sessionId;
        private String filterByUserId;
        private Boolean filterByPublished;
        private String filterByState;
        private String nextToken;
        private Integer maxResults;
        private String filterByRecordingState;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParticipantsRequest model) {
            super(model);
            this.stageArn(model.stageArn);
            this.sessionId(model.sessionId);
            this.filterByUserId(model.filterByUserId);
            this.filterByPublished(model.filterByPublished);
            this.filterByState(model.filterByState);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filterByRecordingState(model.filterByRecordingState);
        }

        public final String getStageArn() {
            return this.stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getFilterByUserId() {
            return this.filterByUserId;
        }

        public final void setFilterByUserId(String filterByUserId) {
            this.filterByUserId = filterByUserId;
        }

        @Override
        public final Builder filterByUserId(String filterByUserId) {
            this.filterByUserId = filterByUserId;
            return this;
        }

        public final Boolean getFilterByPublished() {
            return this.filterByPublished;
        }

        public final void setFilterByPublished(Boolean filterByPublished) {
            this.filterByPublished = filterByPublished;
        }

        @Override
        public final Builder filterByPublished(Boolean filterByPublished) {
            this.filterByPublished = filterByPublished;
            return this;
        }

        public final String getFilterByState() {
            return this.filterByState;
        }

        public final void setFilterByState(String filterByState) {
            this.filterByState = filterByState;
        }

        @Override
        public final Builder filterByState(String filterByState) {
            this.filterByState = filterByState;
            return this;
        }

        @Override
        public final Builder filterByState(ParticipantState filterByState) {
            this.filterByState(filterByState == null ? null : filterByState.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getFilterByRecordingState() {
            return this.filterByRecordingState;
        }

        public final void setFilterByRecordingState(String filterByRecordingState) {
            this.filterByRecordingState = filterByRecordingState;
        }

        @Override
        public final Builder filterByRecordingState(String filterByRecordingState) {
            this.filterByRecordingState = filterByRecordingState;
            return this;
        }

        @Override
        public final Builder filterByRecordingState(ParticipantRecordingFilterByRecordingState filterByRecordingState) {
            this.filterByRecordingState(filterByRecordingState == null ? null : filterByRecordingState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListParticipantsRequest build() {
            return new ListParticipantsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRealTimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListParticipantsRequest> {
        public Builder stageArn(String var1);

        public Builder sessionId(String var1);

        public Builder filterByUserId(String var1);

        public Builder filterByPublished(Boolean var1);

        public Builder filterByState(String var1);

        public Builder filterByState(ParticipantState var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filterByRecordingState(String var1);

        public Builder filterByRecordingState(ParticipantRecordingFilterByRecordingState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

