/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.services.ivsrealtime.model.StageSessionListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.StageSessionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStageSessionsResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListStageSessionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStageSessionsResponse.getter(ListStageSessionsResponse::nextToken)).setter(ListStageSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<StageSessionSummary>> STAGE_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stageSessions").getter(ListStageSessionsResponse.getter(ListStageSessionsResponse::stageSessions)).setter(ListStageSessionsResponse.setter(Builder::stageSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageSessionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STAGE_SESSIONS_FIELD));
    private final String nextToken;
    private final List<StageSessionSummary> stageSessions;

    private ListStageSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.stageSessions = builder.stageSessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStageSessions() {
        return this.stageSessions != null && !(this.stageSessions instanceof SdkAutoConstructList);
    }

    public final List<StageSessionSummary> stageSessions() {
        return this.stageSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStageSessions() ? this.stageSessions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStageSessionsResponse)) {
            return false;
        }
        ListStageSessionsResponse other = (ListStageSessionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStageSessions() == other.hasStageSessions() && Objects.equals(this.stageSessions(), other.stageSessions());
    }

    public final String toString() {
        return ToString.builder((String)"ListStageSessionsResponse").add("NextToken", (Object)this.nextToken()).add("StageSessions", this.hasStageSessions() ? this.stageSessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "stageSessions": {
                return Optional.ofNullable(clazz.cast(this.stageSessions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStageSessionsResponse, T> g) {
        return obj -> g.apply((ListStageSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StageSessionSummary> stageSessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStageSessionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.stageSessions(model.stageSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StageSessionSummary.Builder> getStageSessions() {
            List<StageSessionSummary.Builder> result = StageSessionListCopier.copyToBuilder(this.stageSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStageSessions(Collection<StageSessionSummary.BuilderImpl> stageSessions) {
            this.stageSessions = StageSessionListCopier.copyFromBuilder(stageSessions);
        }

        @Override
        public final Builder stageSessions(Collection<StageSessionSummary> stageSessions) {
            this.stageSessions = StageSessionListCopier.copy(stageSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageSessions(StageSessionSummary ... stageSessions) {
            this.stageSessions(Arrays.asList(stageSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageSessions(Consumer<StageSessionSummary.Builder> ... stageSessions) {
            this.stageSessions(Stream.of(stageSessions).map(c -> (StageSessionSummary)((StageSessionSummary.Builder)StageSessionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStageSessionsResponse build() {
            return new ListStageSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStageSessionsResponse> {
        public Builder nextToken(String var1);

        public Builder stageSessions(Collection<StageSessionSummary> var1);

        public Builder stageSessions(StageSessionSummary ... var1);

        public Builder stageSessions(Consumer<StageSessionSummary.Builder> ... var1);
    }
}

