/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse;

public class ListParticipantEventsIterable
implements SdkIterable<ListParticipantEventsResponse> {
    private final IvsRealTimeClient client;
    private final ListParticipantEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListParticipantEventsIterable(IvsRealTimeClient client, ListParticipantEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListParticipantEventsResponseFetcher();
    }

    public Iterator<ListParticipantEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListParticipantEventsResponseFetcher
    implements SyncPageFetcher<ListParticipantEventsResponse> {
        private ListParticipantEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListParticipantEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListParticipantEventsResponse nextPage(ListParticipantEventsResponse previousPage) {
            if (previousPage == null) {
                return ListParticipantEventsIterable.this.client.listParticipantEvents(ListParticipantEventsIterable.this.firstRequest);
            }
            return ListParticipantEventsIterable.this.client.listParticipantEvents((ListParticipantEventsRequest)((Object)ListParticipantEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

