/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary object describing a participant that has joined a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantSummary.Builder, ParticipantSummary> {
    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstJoinTime")
            .getter(getter(ParticipantSummary::firstJoinTime))
            .setter(setter(Builder::firstJoinTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(ParticipantSummary::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("published").getter(getter(ParticipantSummary::published)).setter(setter(Builder::published))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ParticipantSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ParticipantSummary::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_JOIN_TIME_FIELD,
            PARTICIPANT_ID_FIELD, PUBLISHED_FIELD, STATE_FIELD, USER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant firstJoinTime;

    private final String participantId;

    private final Boolean published;

    private final String state;

    private final String userId;

    private ParticipantSummary(BuilderImpl builder) {
        this.firstJoinTime = builder.firstJoinTime;
        this.participantId = builder.participantId;
        this.published = builder.published;
        this.state = builder.state;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     * </p>
     * 
     * @return ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     */
    public final Instant firstJoinTime() {
        return firstJoinTime;
    }

    /**
     * <p>
     * Unique identifier for this participant, assigned by IVS.
     * </p>
     * 
     * @return Unique identifier for this participant, assigned by IVS.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * Whether the participant ever published to the stage session.
     * </p>
     * 
     * @return Whether the participant ever published to the stage session.
     */
    public final Boolean published() {
        return published;
    }

    /**
     * <p>
     * Whether the participant is connected to or disconnected from the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Whether the participant is connected to or disconnected from the stage.
     * @see ParticipantState
     */
    public final ParticipantState state() {
        return ParticipantState.fromValue(state);
    }

    /**
     * <p>
     * Whether the participant is connected to or disconnected from the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Whether the participant is connected to or disconnected from the stage.
     * @see ParticipantState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
     * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants
     * and should not be used for personally identifying, confidential, or sensitive information</i>.
     * </p>
     * 
     * @return Customer-assigned name to help identify the token; this can be used to link a participant to a user in
     *         the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
     *         participants and should not be used for personally identifying, confidential, or sensitive
     *         information</i>.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(published());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantSummary)) {
            return false;
        }
        ParticipantSummary other = (ParticipantSummary) obj;
        return Objects.equals(firstJoinTime(), other.firstJoinTime()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(published(), other.published()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantSummary").add("FirstJoinTime", firstJoinTime()).add("ParticipantId", participantId())
                .add("Published", published()).add("State", stateAsString()).add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "firstJoinTime":
            return Optional.ofNullable(clazz.cast(firstJoinTime()));
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "published":
            return Optional.ofNullable(clazz.cast(published()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipantSummary, T> g) {
        return obj -> g.apply((ParticipantSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantSummary> {
        /**
         * <p>
         * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         * </p>
         * 
         * @param firstJoinTime
         *        ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstJoinTime(Instant firstJoinTime);

        /**
         * <p>
         * Unique identifier for this participant, assigned by IVS.
         * </p>
         * 
         * @param participantId
         *        Unique identifier for this participant, assigned by IVS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * Whether the participant ever published to the stage session.
         * </p>
         * 
         * @param published
         *        Whether the participant ever published to the stage session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder published(Boolean published);

        /**
         * <p>
         * Whether the participant is connected to or disconnected from the stage.
         * </p>
         * 
         * @param state
         *        Whether the participant is connected to or disconnected from the stage.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(String state);

        /**
         * <p>
         * Whether the participant is connected to or disconnected from the stage.
         * </p>
         * 
         * @param state
         *        Whether the participant is connected to or disconnected from the stage.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(ParticipantState state);

        /**
         * <p>
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
         * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         * participants and should not be used for personally identifying, confidential, or sensitive information</i>.
         * </p>
         * 
         * @param userId
         *        Customer-assigned name to help identify the token; this can be used to link a participant to a user in
         *        the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         *        participants and should not be used for personally identifying, confidential, or sensitive
         *        information</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private Instant firstJoinTime;

        private String participantId;

        private Boolean published;

        private String state;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantSummary model) {
            firstJoinTime(model.firstJoinTime);
            participantId(model.participantId);
            published(model.published);
            state(model.state);
            userId(model.userId);
        }

        public final Instant getFirstJoinTime() {
            return firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final Boolean getPublished() {
            return published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public ParticipantSummary build() {
            return new ParticipantSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
