/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse;

public class ListParticipantEventsPublisher
implements SdkPublisher<ListParticipantEventsResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListParticipantEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListParticipantEventsPublisher(IvsRealTimeAsyncClient client, ListParticipantEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListParticipantEventsPublisher(IvsRealTimeAsyncClient client, ListParticipantEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListParticipantEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListParticipantEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListParticipantEventsResponseFetcher
    implements AsyncPageFetcher<ListParticipantEventsResponse> {
        private ListParticipantEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListParticipantEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListParticipantEventsResponse> nextPage(ListParticipantEventsResponse previousPage) {
            if (previousPage == null) {
                return ListParticipantEventsPublisher.this.client.listParticipantEvents(ListParticipantEventsPublisher.this.firstRequest);
            }
            return ListParticipantEventsPublisher.this.client.listParticipantEvents((ListParticipantEventsRequest)((Object)ListParticipantEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

