/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivschat.model.CloudWatchLogsDestinationConfiguration;
import software.amazon.awssdk.services.ivschat.model.FirehoseDestinationConfiguration;
import software.amazon.awssdk.services.ivschat.model.S3DestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationConfiguration> {
    private static final SdkField<CloudWatchLogsDestinationConfiguration> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(DestinationConfiguration.getter(DestinationConfiguration::cloudWatchLogs)).setter(DestinationConfiguration.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<FirehoseDestinationConfiguration> FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firehose").getter(DestinationConfiguration.getter(DestinationConfiguration::firehose)).setter(DestinationConfiguration.setter(Builder::firehose)).constructor(FirehoseDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(DestinationConfiguration.getter(DestinationConfiguration::s3)).setter(DestinationConfiguration.setter(Builder::s3)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, FIREHOSE_FIELD, S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsDestinationConfiguration cloudWatchLogs;
    private final FirehoseDestinationConfiguration firehose;
    private final S3DestinationConfiguration s3;
    private final Type type;

    private DestinationConfiguration(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    public final CloudWatchLogsDestinationConfiguration cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final FirehoseDestinationConfiguration firehose() {
        return this.firehose;
    }

    public final S3DestinationConfiguration s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration other = (DestinationConfiguration)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.firehose(), other.firehose()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationConfiguration").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("Firehose", (Object)this.firehose()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "firehose": {
                return Optional.ofNullable(clazz.cast(this.firehose()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public static DestinationConfiguration fromCloudWatchLogs(CloudWatchLogsDestinationConfiguration cloudWatchLogs) {
        return (DestinationConfiguration)DestinationConfiguration.builder().cloudWatchLogs(cloudWatchLogs).build();
    }

    public static DestinationConfiguration fromCloudWatchLogs(Consumer<CloudWatchLogsDestinationConfiguration.Builder> cloudWatchLogs) {
        CloudWatchLogsDestinationConfiguration.Builder builder = CloudWatchLogsDestinationConfiguration.builder();
        cloudWatchLogs.accept(builder);
        return DestinationConfiguration.fromCloudWatchLogs((CloudWatchLogsDestinationConfiguration)builder.build());
    }

    public static DestinationConfiguration fromFirehose(FirehoseDestinationConfiguration firehose) {
        return (DestinationConfiguration)DestinationConfiguration.builder().firehose(firehose).build();
    }

    public static DestinationConfiguration fromFirehose(Consumer<FirehoseDestinationConfiguration.Builder> firehose) {
        FirehoseDestinationConfiguration.Builder builder = FirehoseDestinationConfiguration.builder();
        firehose.accept(builder);
        return DestinationConfiguration.fromFirehose((FirehoseDestinationConfiguration)builder.build());
    }

    public static DestinationConfiguration fromS3(S3DestinationConfiguration s3) {
        return (DestinationConfiguration)DestinationConfiguration.builder().s3(s3).build();
    }

    public static DestinationConfiguration fromS3(Consumer<S3DestinationConfiguration.Builder> s3) {
        S3DestinationConfiguration.Builder builder = S3DestinationConfiguration.builder();
        s3.accept(builder);
        return DestinationConfiguration.fromS3((S3DestinationConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfiguration, T> g) {
        return obj -> g.apply((DestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLOUD_WATCH_LOGS,
        FIREHOSE,
        S3,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsDestinationConfiguration cloudWatchLogs;
        private FirehoseDestinationConfiguration firehose;
        private S3DestinationConfiguration s3;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfiguration model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.firehose(model.firehose);
            this.s3(model.s3);
        }

        public final CloudWatchLogsDestinationConfiguration.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsDestinationConfiguration.BuilderImpl cloudWatchLogs) {
            CloudWatchLogsDestinationConfiguration oldValue = this.cloudWatchLogs;
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
            this.handleUnionValueChange(Type.CLOUD_WATCH_LOGS, oldValue, this.cloudWatchLogs);
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsDestinationConfiguration cloudWatchLogs) {
            CloudWatchLogsDestinationConfiguration oldValue = this.cloudWatchLogs;
            this.cloudWatchLogs = cloudWatchLogs;
            this.handleUnionValueChange(Type.CLOUD_WATCH_LOGS, oldValue, this.cloudWatchLogs);
            return this;
        }

        public final FirehoseDestinationConfiguration.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseDestinationConfiguration.BuilderImpl firehose) {
            FirehoseDestinationConfiguration oldValue = this.firehose;
            this.firehose = firehose != null ? firehose.build() : null;
            this.handleUnionValueChange(Type.FIREHOSE, oldValue, this.firehose);
        }

        @Override
        public final Builder firehose(FirehoseDestinationConfiguration firehose) {
            FirehoseDestinationConfiguration oldValue = this.firehose;
            this.firehose = firehose;
            this.handleUnionValueChange(Type.FIREHOSE, oldValue, this.firehose);
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3DestinationConfiguration.BuilderImpl s3) {
            S3DestinationConfiguration oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3DestinationConfiguration s3) {
            S3DestinationConfiguration oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public DestinationConfiguration build() {
            return new DestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationConfiguration> {
        public Builder cloudWatchLogs(CloudWatchLogsDestinationConfiguration var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsDestinationConfiguration.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsDestinationConfiguration)((CloudWatchLogsDestinationConfiguration.Builder)CloudWatchLogsDestinationConfiguration.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder firehose(FirehoseDestinationConfiguration var1);

        default public Builder firehose(Consumer<FirehoseDestinationConfiguration.Builder> firehose) {
            return this.firehose((FirehoseDestinationConfiguration)((FirehoseDestinationConfiguration.Builder)FirehoseDestinationConfiguration.builder().applyMutation(firehose)).build());
        }

        public Builder s3(S3DestinationConfiguration var1);

        default public Builder s3(Consumer<S3DestinationConfiguration.Builder> s3) {
            return this.s3((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3)).build());
        }
    }
}

