/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChatTokenCapability {
    SEND_MESSAGE("SEND_MESSAGE"),
    DISCONNECT_USER("DISCONNECT_USER"),
    DELETE_MESSAGE("DELETE_MESSAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChatTokenCapability> VALUE_MAP;
    private final String value;

    private ChatTokenCapability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChatTokenCapability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChatTokenCapability> knownValues() {
        EnumSet<ChatTokenCapability> knownValues = EnumSet.allOf(ChatTokenCapability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChatTokenCapability.class, ChatTokenCapability::toString);
    }
}

