/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartViewerSessionRevocationRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, StartViewerSessionRevocationRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelArn").getter(StartViewerSessionRevocationRequest.getter(StartViewerSessionRevocationRequest::channelArn)).setter(StartViewerSessionRevocationRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()}).build();
    private static final SdkField<String> VIEWER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("viewerId").getter(StartViewerSessionRevocationRequest.getter(StartViewerSessionRevocationRequest::viewerId)).setter(StartViewerSessionRevocationRequest.setter(Builder::viewerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerId").build()}).build();
    private static final SdkField<Integer> VIEWER_SESSION_VERSIONS_LESS_THAN_OR_EQUAL_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("viewerSessionVersionsLessThanOrEqualTo").getter(StartViewerSessionRevocationRequest.getter(StartViewerSessionRevocationRequest::viewerSessionVersionsLessThanOrEqualTo)).setter(StartViewerSessionRevocationRequest.setter(Builder::viewerSessionVersionsLessThanOrEqualTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerSessionVersionsLessThanOrEqualTo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, VIEWER_ID_FIELD, VIEWER_SESSION_VERSIONS_LESS_THAN_OR_EQUAL_TO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartViewerSessionRevocationRequest.memberNameToFieldInitializer();
    private final String channelArn;
    private final String viewerId;
    private final Integer viewerSessionVersionsLessThanOrEqualTo;

    private StartViewerSessionRevocationRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.viewerId = builder.viewerId;
        this.viewerSessionVersionsLessThanOrEqualTo = builder.viewerSessionVersionsLessThanOrEqualTo;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String viewerId() {
        return this.viewerId;
    }

    public final Integer viewerSessionVersionsLessThanOrEqualTo() {
        return this.viewerSessionVersionsLessThanOrEqualTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerSessionVersionsLessThanOrEqualTo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartViewerSessionRevocationRequest)) {
            return false;
        }
        StartViewerSessionRevocationRequest other = (StartViewerSessionRevocationRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.viewerId(), other.viewerId()) && Objects.equals(this.viewerSessionVersionsLessThanOrEqualTo(), other.viewerSessionVersionsLessThanOrEqualTo());
    }

    public final String toString() {
        return ToString.builder((String)"StartViewerSessionRevocationRequest").add("ChannelArn", (Object)this.channelArn()).add("ViewerId", (Object)this.viewerId()).add("ViewerSessionVersionsLessThanOrEqualTo", (Object)this.viewerSessionVersionsLessThanOrEqualTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "viewerId": {
                return Optional.ofNullable(clazz.cast(this.viewerId()));
            }
            case "viewerSessionVersionsLessThanOrEqualTo": {
                return Optional.ofNullable(clazz.cast(this.viewerSessionVersionsLessThanOrEqualTo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("viewerId", VIEWER_ID_FIELD);
        map.put("viewerSessionVersionsLessThanOrEqualTo", VIEWER_SESSION_VERSIONS_LESS_THAN_OR_EQUAL_TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartViewerSessionRevocationRequest, T> g) {
        return obj -> g.apply((StartViewerSessionRevocationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String viewerId;
        private Integer viewerSessionVersionsLessThanOrEqualTo;

        private BuilderImpl() {
        }

        private BuilderImpl(StartViewerSessionRevocationRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.viewerId(model.viewerId);
            this.viewerSessionVersionsLessThanOrEqualTo(model.viewerSessionVersionsLessThanOrEqualTo);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getViewerId() {
            return this.viewerId;
        }

        public final void setViewerId(String viewerId) {
            this.viewerId = viewerId;
        }

        @Override
        public final Builder viewerId(String viewerId) {
            this.viewerId = viewerId;
            return this;
        }

        public final Integer getViewerSessionVersionsLessThanOrEqualTo() {
            return this.viewerSessionVersionsLessThanOrEqualTo;
        }

        public final void setViewerSessionVersionsLessThanOrEqualTo(Integer viewerSessionVersionsLessThanOrEqualTo) {
            this.viewerSessionVersionsLessThanOrEqualTo = viewerSessionVersionsLessThanOrEqualTo;
        }

        @Override
        public final Builder viewerSessionVersionsLessThanOrEqualTo(Integer viewerSessionVersionsLessThanOrEqualTo) {
            this.viewerSessionVersionsLessThanOrEqualTo = viewerSessionVersionsLessThanOrEqualTo;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartViewerSessionRevocationRequest build() {
            return new StartViewerSessionRevocationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartViewerSessionRevocationRequest> {
        public Builder channelArn(String var1);

        public Builder viewerId(String var1);

        public Builder viewerSessionVersionsLessThanOrEqualTo(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

