/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSessionSummary> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(StreamSessionSummary.getter(StreamSessionSummary::streamId)).setter(StreamSessionSummary.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StreamSessionSummary.getter(StreamSessionSummary::startTime)).setter(StreamSessionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StreamSessionSummary.getter(StreamSessionSummary::endTime)).setter(StreamSessionSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> HAS_ERROR_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasErrorEvent").getter(StreamSessionSummary.getter(StreamSessionSummary::hasErrorEvent)).setter(StreamSessionSummary.setter(Builder::hasErrorEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasErrorEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, HAS_ERROR_EVENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamId;
    private final Instant startTime;
    private final Instant endTime;
    private final Boolean hasErrorEvent;

    private StreamSessionSummary(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.hasErrorEvent = builder.hasErrorEvent;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Boolean hasErrorEvent() {
        return this.hasErrorEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorEvent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSessionSummary)) {
            return false;
        }
        StreamSessionSummary other = (StreamSessionSummary)obj;
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.hasErrorEvent(), other.hasErrorEvent());
    }

    public final String toString() {
        return ToString.builder((String)"StreamSessionSummary").add("StreamId", (Object)this.streamId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("HasErrorEvent", (Object)this.hasErrorEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "hasErrorEvent": {
                return Optional.ofNullable(clazz.cast(this.hasErrorEvent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSessionSummary, T> g) {
        return obj -> g.apply((StreamSessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamId;
        private Instant startTime;
        private Instant endTime;
        private Boolean hasErrorEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSessionSummary model) {
            this.streamId(model.streamId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.hasErrorEvent(model.hasErrorEvent);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getHasErrorEvent() {
            return this.hasErrorEvent;
        }

        public final void setHasErrorEvent(Boolean hasErrorEvent) {
            this.hasErrorEvent = hasErrorEvent;
        }

        @Override
        public final Builder hasErrorEvent(Boolean hasErrorEvent) {
            this.hasErrorEvent = hasErrorEvent;
            return this;
        }

        public StreamSessionSummary build() {
            return new StreamSessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSessionSummary> {
        public Builder streamId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder hasErrorEvent(Boolean var1);
    }
}

