/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivs.model.ChannelLatencyMode;
import software.amazon.awssdk.services.ivs.model.ChannelType;
import software.amazon.awssdk.services.ivs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Channel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Channel> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Channel.getter(Channel::arn)).setter(Channel.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("authorized").getter(Channel.getter(Channel::authorized)).setter(Channel.setter(Builder::authorized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()}).build();
    private static final SdkField<String> INGEST_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestEndpoint").getter(Channel.getter(Channel::ingestEndpoint)).setter(Channel.setter(Builder::ingestEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestEndpoint").build()}).build();
    private static final SdkField<Boolean> INSECURE_INGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("insecureIngest").getter(Channel.getter(Channel::insecureIngest)).setter(Channel.setter(Builder::insecureIngest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureIngest").build()}).build();
    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latencyMode").getter(Channel.getter(Channel::latencyModeAsString)).setter(Channel.setter(Builder::latencyMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Channel.getter(Channel::name)).setter(Channel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PLAYBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("playbackUrl").getter(Channel.getter(Channel::playbackUrl)).setter(Channel.setter(Builder::playbackUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackUrl").build()}).build();
    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingConfigurationArn").getter(Channel.getter(Channel::recordingConfigurationArn)).setter(Channel.setter(Builder::recordingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Channel.getter(Channel::tags)).setter(Channel.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Channel.getter(Channel::typeAsString)).setter(Channel.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZED_FIELD, INGEST_ENDPOINT_FIELD, INSECURE_INGEST_FIELD, LATENCY_MODE_FIELD, NAME_FIELD, PLAYBACK_URL_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Boolean authorized;
    private final String ingestEndpoint;
    private final Boolean insecureIngest;
    private final String latencyMode;
    private final String name;
    private final String playbackUrl;
    private final String recordingConfigurationArn;
    private final Map<String, String> tags;
    private final String type;

    private Channel(BuilderImpl builder) {
        this.arn = builder.arn;
        this.authorized = builder.authorized;
        this.ingestEndpoint = builder.ingestEndpoint;
        this.insecureIngest = builder.insecureIngest;
        this.latencyMode = builder.latencyMode;
        this.name = builder.name;
        this.playbackUrl = builder.playbackUrl;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean authorized() {
        return this.authorized;
    }

    public final String ingestEndpoint() {
        return this.ingestEndpoint;
    }

    public final Boolean insecureIngest() {
        return this.insecureIngest;
    }

    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(this.latencyMode);
    }

    public final String latencyModeAsString() {
        return this.latencyMode;
    }

    public final String name() {
        return this.name;
    }

    public final String playbackUrl() {
        return this.playbackUrl;
    }

    public final String recordingConfigurationArn() {
        return this.recordingConfigurationArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorized());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureIngest());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authorized(), other.authorized()) && Objects.equals(this.ingestEndpoint(), other.ingestEndpoint()) && Objects.equals(this.insecureIngest(), other.insecureIngest()) && Objects.equals(this.latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.playbackUrl(), other.playbackUrl()) && Objects.equals(this.recordingConfigurationArn(), other.recordingConfigurationArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Channel").add("Arn", (Object)this.arn()).add("Authorized", (Object)this.authorized()).add("IngestEndpoint", (Object)this.ingestEndpoint()).add("InsecureIngest", (Object)this.insecureIngest()).add("LatencyMode", (Object)this.latencyModeAsString()).add("Name", (Object)this.name()).add("PlaybackUrl", (Object)this.playbackUrl()).add("RecordingConfigurationArn", (Object)this.recordingConfigurationArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "authorized": {
                return Optional.ofNullable(clazz.cast(this.authorized()));
            }
            case "ingestEndpoint": {
                return Optional.ofNullable(clazz.cast(this.ingestEndpoint()));
            }
            case "insecureIngest": {
                return Optional.ofNullable(clazz.cast(this.insecureIngest()));
            }
            case "latencyMode": {
                return Optional.ofNullable(clazz.cast(this.latencyModeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "playbackUrl": {
                return Optional.ofNullable(clazz.cast(this.playbackUrl()));
            }
            case "recordingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.recordingConfigurationArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Boolean authorized;
        private String ingestEndpoint;
        private Boolean insecureIngest;
        private String latencyMode;
        private String name;
        private String playbackUrl;
        private String recordingConfigurationArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.arn(model.arn);
            this.authorized(model.authorized);
            this.ingestEndpoint(model.ingestEndpoint);
            this.insecureIngest(model.insecureIngest);
            this.latencyMode(model.latencyMode);
            this.name(model.name);
            this.playbackUrl(model.playbackUrl);
            this.recordingConfigurationArn(model.recordingConfigurationArn);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAuthorized() {
            return this.authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final String getIngestEndpoint() {
            return this.ingestEndpoint;
        }

        public final void setIngestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
        }

        @Override
        public final Builder ingestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
            return this;
        }

        public final Boolean getInsecureIngest() {
            return this.insecureIngest;
        }

        public final void setInsecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
        }

        @Override
        public final Builder insecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        public final String getLatencyMode() {
            return this.latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlaybackUrl() {
            return this.playbackUrl;
        }

        public final void setPlaybackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
        }

        @Override
        public final Builder playbackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return this.recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Channel build() {
            return new Channel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Channel> {
        public Builder arn(String var1);

        public Builder authorized(Boolean var1);

        public Builder ingestEndpoint(String var1);

        public Builder insecureIngest(Boolean var1);

        public Builder latencyMode(String var1);

        public Builder latencyMode(ChannelLatencyMode var1);

        public Builder name(String var1);

        public Builder playbackUrl(String var1);

        public Builder recordingConfigurationArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);
    }
}

