/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.ChannelLatencyMode;
import software.amazon.awssdk.services.ivs.model.ChannelType;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, UpdateChannelRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateChannelRequest.getter(UpdateChannelRequest::arn)).setter(UpdateChannelRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("authorized").getter(UpdateChannelRequest.getter(UpdateChannelRequest::authorized)).setter(UpdateChannelRequest.setter(Builder::authorized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()}).build();
    private static final SdkField<Boolean> INSECURE_INGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("insecureIngest").getter(UpdateChannelRequest.getter(UpdateChannelRequest::insecureIngest)).setter(UpdateChannelRequest.setter(Builder::insecureIngest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureIngest").build()}).build();
    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latencyMode").getter(UpdateChannelRequest.getter(UpdateChannelRequest::latencyModeAsString)).setter(UpdateChannelRequest.setter(Builder::latencyMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateChannelRequest.getter(UpdateChannelRequest::name)).setter(UpdateChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingConfigurationArn").getter(UpdateChannelRequest.getter(UpdateChannelRequest::recordingConfigurationArn)).setter(UpdateChannelRequest.setter(Builder::recordingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UpdateChannelRequest.getter(UpdateChannelRequest::typeAsString)).setter(UpdateChannelRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZED_FIELD, INSECURE_INGEST_FIELD, LATENCY_MODE_FIELD, NAME_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, TYPE_FIELD));
    private final String arn;
    private final Boolean authorized;
    private final Boolean insecureIngest;
    private final String latencyMode;
    private final String name;
    private final String recordingConfigurationArn;
    private final String type;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authorized = builder.authorized;
        this.insecureIngest = builder.insecureIngest;
        this.latencyMode = builder.latencyMode;
        this.name = builder.name;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean authorized() {
        return this.authorized;
    }

    public final Boolean insecureIngest() {
        return this.insecureIngest;
    }

    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(this.latencyMode);
    }

    public final String latencyModeAsString() {
        return this.latencyMode;
    }

    public final String name() {
        return this.name;
    }

    public final String recordingConfigurationArn() {
        return this.recordingConfigurationArn;
    }

    public final ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorized());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureIngest());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authorized(), other.authorized()) && Objects.equals(this.insecureIngest(), other.insecureIngest()) && Objects.equals(this.latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recordingConfigurationArn(), other.recordingConfigurationArn()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelRequest").add("Arn", (Object)this.arn()).add("Authorized", (Object)this.authorized()).add("InsecureIngest", (Object)this.insecureIngest()).add("LatencyMode", (Object)this.latencyModeAsString()).add("Name", (Object)this.name()).add("RecordingConfigurationArn", (Object)this.recordingConfigurationArn()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "authorized": {
                return Optional.ofNullable(clazz.cast(this.authorized()));
            }
            case "insecureIngest": {
                return Optional.ofNullable(clazz.cast(this.insecureIngest()));
            }
            case "latencyMode": {
                return Optional.ofNullable(clazz.cast(this.latencyModeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recordingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.recordingConfigurationArn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private String arn;
        private Boolean authorized;
        private Boolean insecureIngest;
        private String latencyMode;
        private String name;
        private String recordingConfigurationArn;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            this.arn(model.arn);
            this.authorized(model.authorized);
            this.insecureIngest(model.insecureIngest);
            this.latencyMode(model.latencyMode);
            this.name(model.name);
            this.recordingConfigurationArn(model.recordingConfigurationArn);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAuthorized() {
            return this.authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final Boolean getInsecureIngest() {
            return this.insecureIngest;
        }

        public final void setInsecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
        }

        @Override
        public final Builder insecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        public final String getLatencyMode() {
            return this.latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return this.recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelRequest> {
        public Builder arn(String var1);

        public Builder authorized(Boolean var1);

        public Builder insecureIngest(Boolean var1);

        public Builder latencyMode(String var1);

        public Builder latencyMode(ChannelLatencyMode var1);

        public Builder name(String var1);

        public Builder recordingConfigurationArn(String var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

