/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse;

public class ListStreamSessionsIterable
implements SdkIterable<ListStreamSessionsResponse> {
    private final IvsClient client;
    private final ListStreamSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamSessionsIterable(IvsClient client, ListStreamSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamSessionsResponseFetcher();
    }

    public Iterator<ListStreamSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStreamSessionsResponseFetcher
    implements SyncPageFetcher<ListStreamSessionsResponse> {
        private ListStreamSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamSessionsResponse nextPage(ListStreamSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamSessionsIterable.this.client.listStreamSessions(ListStreamSessionsIterable.this.firstRequest);
            }
            return ListStreamSessionsIterable.this.client.listStreamSessions((ListStreamSessionsRequest)((Object)ListStreamSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

