/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsAsyncClient;
import software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest;
import software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse;

public class ListPlaybackKeyPairsPublisher
implements SdkPublisher<ListPlaybackKeyPairsResponse> {
    private final IvsAsyncClient client;
    private final ListPlaybackKeyPairsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlaybackKeyPairsPublisher(IvsAsyncClient client, ListPlaybackKeyPairsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlaybackKeyPairsPublisher(IvsAsyncClient client, ListPlaybackKeyPairsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlaybackKeyPairsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlaybackKeyPairsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPlaybackKeyPairsResponseFetcher
    implements AsyncPageFetcher<ListPlaybackKeyPairsResponse> {
        private ListPlaybackKeyPairsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaybackKeyPairsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlaybackKeyPairsResponse> nextPage(ListPlaybackKeyPairsResponse previousPage) {
            if (previousPage == null) {
                return ListPlaybackKeyPairsPublisher.this.client.listPlaybackKeyPairs(ListPlaybackKeyPairsPublisher.this.firstRequest);
            }
            return ListPlaybackKeyPairsPublisher.this.client.listPlaybackKeyPairs((ListPlaybackKeyPairsRequest)((Object)ListPlaybackKeyPairsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

