/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.RecordingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThumbnailConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThumbnailConfiguration> {
    private static final SdkField<String> RECORDING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingMode").getter(ThumbnailConfiguration.getter(ThumbnailConfiguration::recordingModeAsString)).setter(ThumbnailConfiguration.setter(Builder::recordingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingMode").build()}).build();
    private static final SdkField<Long> TARGET_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetIntervalSeconds").getter(ThumbnailConfiguration.getter(ThumbnailConfiguration::targetIntervalSeconds)).setter(ThumbnailConfiguration.setter(Builder::targetIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIntervalSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDING_MODE_FIELD, TARGET_INTERVAL_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recordingMode;
    private final Long targetIntervalSeconds;

    private ThumbnailConfiguration(BuilderImpl builder) {
        this.recordingMode = builder.recordingMode;
        this.targetIntervalSeconds = builder.targetIntervalSeconds;
    }

    public final RecordingMode recordingMode() {
        return RecordingMode.fromValue(this.recordingMode);
    }

    public final String recordingModeAsString() {
        return this.recordingMode;
    }

    public final Long targetIntervalSeconds() {
        return this.targetIntervalSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIntervalSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailConfiguration)) {
            return false;
        }
        ThumbnailConfiguration other = (ThumbnailConfiguration)obj;
        return Objects.equals(this.recordingModeAsString(), other.recordingModeAsString()) && Objects.equals(this.targetIntervalSeconds(), other.targetIntervalSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"ThumbnailConfiguration").add("RecordingMode", (Object)this.recordingModeAsString()).add("TargetIntervalSeconds", (Object)this.targetIntervalSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recordingMode": {
                return Optional.ofNullable(clazz.cast(this.recordingModeAsString()));
            }
            case "targetIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.targetIntervalSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThumbnailConfiguration, T> g) {
        return obj -> g.apply((ThumbnailConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordingMode;
        private Long targetIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ThumbnailConfiguration model) {
            this.recordingMode(model.recordingMode);
            this.targetIntervalSeconds(model.targetIntervalSeconds);
        }

        public final String getRecordingMode() {
            return this.recordingMode;
        }

        public final void setRecordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
        }

        @Override
        @Transient
        public final Builder recordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode(recordingMode == null ? null : recordingMode.toString());
            return this;
        }

        public final Long getTargetIntervalSeconds() {
            return this.targetIntervalSeconds;
        }

        public final void setTargetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
        }

        @Override
        @Transient
        public final Builder targetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
            return this;
        }

        public ThumbnailConfiguration build() {
            return new ThumbnailConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThumbnailConfiguration> {
        public Builder recordingMode(String var1);

        public Builder recordingMode(RecordingMode var1);

        public Builder targetIntervalSeconds(Long var1);
    }
}

