/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSessionSummary> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StreamSessionSummary.getter(StreamSessionSummary::endTime)).setter(StreamSessionSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> HAS_ERROR_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasErrorEvent").getter(StreamSessionSummary.getter(StreamSessionSummary::hasErrorEvent)).setter(StreamSessionSummary.setter(Builder::hasErrorEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasErrorEvent").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StreamSessionSummary.getter(StreamSessionSummary::startTime)).setter(StreamSessionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(StreamSessionSummary.getter(StreamSessionSummary::streamId)).setter(StreamSessionSummary.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, HAS_ERROR_EVENT_FIELD, START_TIME_FIELD, STREAM_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant endTime;
    private final Boolean hasErrorEvent;
    private final Instant startTime;
    private final String streamId;

    private StreamSessionSummary(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.hasErrorEvent = builder.hasErrorEvent;
        this.startTime = builder.startTime;
        this.streamId = builder.streamId;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Boolean hasErrorEvent() {
        return this.hasErrorEvent;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String streamId() {
        return this.streamId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSessionSummary)) {
            return false;
        }
        StreamSessionSummary other = (StreamSessionSummary)obj;
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.hasErrorEvent(), other.hasErrorEvent()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.streamId(), other.streamId());
    }

    public final String toString() {
        return ToString.builder((String)"StreamSessionSummary").add("EndTime", (Object)this.endTime()).add("HasErrorEvent", (Object)this.hasErrorEvent()).add("StartTime", (Object)this.startTime()).add("StreamId", (Object)this.streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "hasErrorEvent": {
                return Optional.ofNullable(clazz.cast(this.hasErrorEvent()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSessionSummary, T> g) {
        return obj -> g.apply((StreamSessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant endTime;
        private Boolean hasErrorEvent;
        private Instant startTime;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSessionSummary model) {
            this.endTime(model.endTime);
            this.hasErrorEvent(model.hasErrorEvent);
            this.startTime(model.startTime);
            this.streamId(model.streamId);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getHasErrorEvent() {
            return this.hasErrorEvent;
        }

        public final void setHasErrorEvent(Boolean hasErrorEvent) {
            this.hasErrorEvent = hasErrorEvent;
        }

        @Override
        @Transient
        public final Builder hasErrorEvent(Boolean hasErrorEvent) {
            this.hasErrorEvent = hasErrorEvent;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        @Transient
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public StreamSessionSummary build() {
            return new StreamSessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSessionSummary> {
        public Builder endTime(Instant var1);

        public Builder hasErrorEvent(Boolean var1);

        public Builder startTime(Instant var1);

        public Builder streamId(String var1);
    }
}

