/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivs.model.ChannelLatencyMode;
import software.amazon.awssdk.services.ivs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ChannelSummary.getter(ChannelSummary::arn)).setter(ChannelSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("authorized").getter(ChannelSummary.getter(ChannelSummary::authorized)).setter(ChannelSummary.setter(Builder::authorized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()}).build();
    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latencyMode").getter(ChannelSummary.getter(ChannelSummary::latencyModeAsString)).setter(ChannelSummary.setter(Builder::latencyMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ChannelSummary.getter(ChannelSummary::name)).setter(ChannelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingConfigurationArn").getter(ChannelSummary.getter(ChannelSummary::recordingConfigurationArn)).setter(ChannelSummary.setter(Builder::recordingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ChannelSummary.getter(ChannelSummary::tags)).setter(ChannelSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZED_FIELD, LATENCY_MODE_FIELD, NAME_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Boolean authorized;
    private final String latencyMode;
    private final String name;
    private final String recordingConfigurationArn;
    private final Map<String, String> tags;

    private ChannelSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.authorized = builder.authorized;
        this.latencyMode = builder.latencyMode;
        this.name = builder.name;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean authorized() {
        return this.authorized;
    }

    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(this.latencyMode);
    }

    public final String latencyModeAsString() {
        return this.latencyMode;
    }

    public final String name() {
        return this.name;
    }

    public final String recordingConfigurationArn() {
        return this.recordingConfigurationArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorized());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSummary)) {
            return false;
        }
        ChannelSummary other = (ChannelSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authorized(), other.authorized()) && Objects.equals(this.latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recordingConfigurationArn(), other.recordingConfigurationArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelSummary").add("Arn", (Object)this.arn()).add("Authorized", (Object)this.authorized()).add("LatencyMode", (Object)this.latencyModeAsString()).add("Name", (Object)this.name()).add("RecordingConfigurationArn", (Object)this.recordingConfigurationArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "authorized": {
                return Optional.ofNullable(clazz.cast(this.authorized()));
            }
            case "latencyMode": {
                return Optional.ofNullable(clazz.cast(this.latencyModeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recordingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.recordingConfigurationArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelSummary, T> g) {
        return obj -> g.apply((ChannelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Boolean authorized;
        private String latencyMode;
        private String name;
        private String recordingConfigurationArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSummary model) {
            this.arn(model.arn);
            this.authorized(model.authorized);
            this.latencyMode(model.latencyMode);
            this.name(model.name);
            this.recordingConfigurationArn(model.recordingConfigurationArn);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAuthorized() {
            return this.authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        @Transient
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final String getLatencyMode() {
            return this.latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        @Transient
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        @Transient
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return this.recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        @Transient
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public ChannelSummary build() {
            return new ChannelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelSummary> {
        public Builder arn(String var1);

        public Builder authorized(Boolean var1);

        public Builder latencyMode(String var1);

        public Builder latencyMode(ChannelLatencyMode var1);

        public Builder name(String var1);

        public Builder recordingConfigurationArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

