/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StreamState {
    LIVE("LIVE"),
    OFFLINE("OFFLINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StreamState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StreamState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamState> knownValues() {
        return Stream.of(StreamState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

