/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse;
import software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary;

public class ListRecordingConfigurationsIterable
implements SdkIterable<ListRecordingConfigurationsResponse> {
    private final IvsClient client;
    private final ListRecordingConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecordingConfigurationsIterable(IvsClient client, ListRecordingConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecordingConfigurationsResponseFetcher();
    }

    public Iterator<ListRecordingConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecordingConfigurationSummary> recordingConfigurations() {
        Function<ListRecordingConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recordingConfigurations() != null) {
                return response.recordingConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecordingConfigurationsResponseFetcher
    implements SyncPageFetcher<ListRecordingConfigurationsResponse> {
        private ListRecordingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecordingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecordingConfigurationsResponse nextPage(ListRecordingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecordingConfigurationsIterable.this.client.listRecordingConfigurations(ListRecordingConfigurationsIterable.this.firstRequest);
            }
            return ListRecordingConfigurationsIterable.this.client.listRecordingConfigurations((ListRecordingConfigurationsRequest)((Object)ListRecordingConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

