/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.IvsResponse;
import software.amazon.awssdk.services.ivs.model.PlaybackKeyPairListCopier;
import software.amazon.awssdk.services.ivs.model.PlaybackKeyPairSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlaybackKeyPairsResponse
extends IvsResponse
implements ToCopyableBuilder<Builder, ListPlaybackKeyPairsResponse> {
    private static final SdkField<List<PlaybackKeyPairSummary>> KEY_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPlaybackKeyPairsResponse.getter(ListPlaybackKeyPairsResponse::keyPairs)).setter(ListPlaybackKeyPairsResponse.setter(Builder::keyPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlaybackKeyPairSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPlaybackKeyPairsResponse.getter(ListPlaybackKeyPairsResponse::nextToken)).setter(ListPlaybackKeyPairsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIRS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PlaybackKeyPairSummary> keyPairs;
    private final String nextToken;

    private ListPlaybackKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
        this.nextToken = builder.nextToken;
    }

    public boolean hasKeyPairs() {
        return this.keyPairs != null && !(this.keyPairs instanceof SdkAutoConstructList);
    }

    public List<PlaybackKeyPairSummary> keyPairs() {
        return this.keyPairs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlaybackKeyPairsResponse)) {
            return false;
        }
        ListPlaybackKeyPairsResponse other = (ListPlaybackKeyPairsResponse)((Object)obj);
        return Objects.equals(this.keyPairs(), other.keyPairs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPlaybackKeyPairsResponse").add("KeyPairs", this.keyPairs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyPairs": {
                return Optional.ofNullable(clazz.cast(this.keyPairs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlaybackKeyPairsResponse, T> g) {
        return obj -> g.apply((ListPlaybackKeyPairsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsResponse.BuilderImpl
    implements Builder {
        private List<PlaybackKeyPairSummary> keyPairs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlaybackKeyPairsResponse model) {
            super(model);
            this.keyPairs(model.keyPairs);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlaybackKeyPairSummary.Builder> getKeyPairs() {
            return this.keyPairs != null ? (Collection)this.keyPairs.stream().map(PlaybackKeyPairSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<PlaybackKeyPairSummary> keyPairs) {
            this.keyPairs = PlaybackKeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(PlaybackKeyPairSummary ... keyPairs) {
            this.keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(Consumer<PlaybackKeyPairSummary.Builder> ... keyPairs) {
            this.keyPairs(Stream.of(keyPairs).map(c -> (PlaybackKeyPairSummary)((PlaybackKeyPairSummary.Builder)PlaybackKeyPairSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPairs(Collection<PlaybackKeyPairSummary.BuilderImpl> keyPairs) {
            this.keyPairs = PlaybackKeyPairListCopier.copyFromBuilder(keyPairs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlaybackKeyPairsResponse build() {
            return new ListPlaybackKeyPairsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlaybackKeyPairsResponse> {
        public Builder keyPairs(Collection<PlaybackKeyPairSummary> var1);

        public Builder keyPairs(PlaybackKeyPairSummary ... var1);

        public Builder keyPairs(Consumer<PlaybackKeyPairSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

