/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWirelessGatewayCertificateResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetWirelessGatewayCertificateResponse> {
    private static final SdkField<String> IOT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IotCertificateId").getter(GetWirelessGatewayCertificateResponse.getter(GetWirelessGatewayCertificateResponse::iotCertificateId)).setter(GetWirelessGatewayCertificateResponse.setter(Builder::iotCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotCertificateId").build()}).build();
    private static final SdkField<String> LO_RA_WAN_NETWORK_SERVER_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoRaWANNetworkServerCertificateId").getter(GetWirelessGatewayCertificateResponse.getter(GetWirelessGatewayCertificateResponse::loRaWANNetworkServerCertificateId)).setter(GetWirelessGatewayCertificateResponse.setter(Builder::loRaWANNetworkServerCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWANNetworkServerCertificateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOT_CERTIFICATE_ID_FIELD, LO_RA_WAN_NETWORK_SERVER_CERTIFICATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWirelessGatewayCertificateResponse.memberNameToFieldInitializer();
    private final String iotCertificateId;
    private final String loRaWANNetworkServerCertificateId;

    private GetWirelessGatewayCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.iotCertificateId = builder.iotCertificateId;
        this.loRaWANNetworkServerCertificateId = builder.loRaWANNetworkServerCertificateId;
    }

    public final String iotCertificateId() {
        return this.iotCertificateId;
    }

    public final String loRaWANNetworkServerCertificateId() {
        return this.loRaWANNetworkServerCertificateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.iotCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWANNetworkServerCertificateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayCertificateResponse)) {
            return false;
        }
        GetWirelessGatewayCertificateResponse other = (GetWirelessGatewayCertificateResponse)((Object)obj);
        return Objects.equals(this.iotCertificateId(), other.iotCertificateId()) && Objects.equals(this.loRaWANNetworkServerCertificateId(), other.loRaWANNetworkServerCertificateId());
    }

    public final String toString() {
        return ToString.builder((String)"GetWirelessGatewayCertificateResponse").add("IotCertificateId", (Object)this.iotCertificateId()).add("LoRaWANNetworkServerCertificateId", (Object)this.loRaWANNetworkServerCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IotCertificateId": {
                return Optional.ofNullable(clazz.cast(this.iotCertificateId()));
            }
            case "LoRaWANNetworkServerCertificateId": {
                return Optional.ofNullable(clazz.cast(this.loRaWANNetworkServerCertificateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IotCertificateId", IOT_CERTIFICATE_ID_FIELD);
        map.put("LoRaWANNetworkServerCertificateId", LO_RA_WAN_NETWORK_SERVER_CERTIFICATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayCertificateResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayCertificateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String iotCertificateId;
        private String loRaWANNetworkServerCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayCertificateResponse model) {
            super(model);
            this.iotCertificateId(model.iotCertificateId);
            this.loRaWANNetworkServerCertificateId(model.loRaWANNetworkServerCertificateId);
        }

        public final String getIotCertificateId() {
            return this.iotCertificateId;
        }

        public final void setIotCertificateId(String iotCertificateId) {
            this.iotCertificateId = iotCertificateId;
        }

        @Override
        public final Builder iotCertificateId(String iotCertificateId) {
            this.iotCertificateId = iotCertificateId;
            return this;
        }

        public final String getLoRaWANNetworkServerCertificateId() {
            return this.loRaWANNetworkServerCertificateId;
        }

        public final void setLoRaWANNetworkServerCertificateId(String loRaWANNetworkServerCertificateId) {
            this.loRaWANNetworkServerCertificateId = loRaWANNetworkServerCertificateId;
        }

        @Override
        public final Builder loRaWANNetworkServerCertificateId(String loRaWANNetworkServerCertificateId) {
            this.loRaWANNetworkServerCertificateId = loRaWANNetworkServerCertificateId;
            return this;
        }

        @Override
        public GetWirelessGatewayCertificateResponse build() {
            return new GetWirelessGatewayCertificateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWirelessGatewayCertificateResponse> {
        public Builder iotCertificateId(String var1);

        public Builder loRaWANNetworkServerCertificateId(String var1);
    }
}

