/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerMulticastGroupListCopier;
import software.amazon.awssdk.services.iotwireless.model.Tag;
import software.amazon.awssdk.services.iotwireless.model.TagListCopier;
import software.amazon.awssdk.services.iotwireless.model.TraceContent;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceListCopier;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkAnalyzerConfigurationRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, CreateNetworkAnalyzerConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::name)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<TraceContent> TRACE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TraceContent").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::traceContent)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::traceContent)).constructor(TraceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceContent").build()}).build();
    private static final SdkField<List<String>> WIRELESS_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDevices").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::wirelessDevices)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::wirelessDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WIRELESS_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessGateways").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::wirelessGateways)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::wirelessGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::description)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::tags)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::clientRequestToken)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<String>> MULTICAST_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MulticastGroups").getter(CreateNetworkAnalyzerConfigurationRequest.getter(CreateNetworkAnalyzerConfigurationRequest::multicastGroups)).setter(CreateNetworkAnalyzerConfigurationRequest.setter(Builder::multicastGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRACE_CONTENT_FIELD, WIRELESS_DEVICES_FIELD, WIRELESS_GATEWAYS_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, MULTICAST_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNetworkAnalyzerConfigurationRequest.memberNameToFieldInitializer();
    private final String name;
    private final TraceContent traceContent;
    private final List<String> wirelessDevices;
    private final List<String> wirelessGateways;
    private final String description;
    private final List<Tag> tags;
    private final String clientRequestToken;
    private final List<String> multicastGroups;

    private CreateNetworkAnalyzerConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.traceContent = builder.traceContent;
        this.wirelessDevices = builder.wirelessDevices;
        this.wirelessGateways = builder.wirelessGateways;
        this.description = builder.description;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
        this.multicastGroups = builder.multicastGroups;
    }

    public final String name() {
        return this.name;
    }

    public final TraceContent traceContent() {
        return this.traceContent;
    }

    public final boolean hasWirelessDevices() {
        return this.wirelessDevices != null && !(this.wirelessDevices instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessDevices() {
        return this.wirelessDevices;
    }

    public final boolean hasWirelessGateways() {
        return this.wirelessGateways != null && !(this.wirelessGateways instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessGateways() {
        return this.wirelessGateways;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasMulticastGroups() {
        return this.multicastGroups != null && !(this.multicastGroups instanceof SdkAutoConstructList);
    }

    public final List<String> multicastGroups() {
        return this.multicastGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDevices() ? this.wirelessDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessGateways() ? this.wirelessGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMulticastGroups() ? this.multicastGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAnalyzerConfigurationRequest)) {
            return false;
        }
        CreateNetworkAnalyzerConfigurationRequest other = (CreateNetworkAnalyzerConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.traceContent(), other.traceContent()) && this.hasWirelessDevices() == other.hasWirelessDevices() && Objects.equals(this.wirelessDevices(), other.wirelessDevices()) && this.hasWirelessGateways() == other.hasWirelessGateways() && Objects.equals(this.wirelessGateways(), other.wirelessGateways()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasMulticastGroups() == other.hasMulticastGroups() && Objects.equals(this.multicastGroups(), other.multicastGroups());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkAnalyzerConfigurationRequest").add("Name", (Object)this.name()).add("TraceContent", (Object)this.traceContent()).add("WirelessDevices", this.hasWirelessDevices() ? this.wirelessDevices() : null).add("WirelessGateways", this.hasWirelessGateways() ? this.wirelessGateways() : null).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("MulticastGroups", this.hasMulticastGroups() ? this.multicastGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TraceContent": {
                return Optional.ofNullable(clazz.cast(this.traceContent()));
            }
            case "WirelessDevices": {
                return Optional.ofNullable(clazz.cast(this.wirelessDevices()));
            }
            case "WirelessGateways": {
                return Optional.ofNullable(clazz.cast(this.wirelessGateways()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "MulticastGroups": {
                return Optional.ofNullable(clazz.cast(this.multicastGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("TraceContent", TRACE_CONTENT_FIELD);
        map.put("WirelessDevices", WIRELESS_DEVICES_FIELD);
        map.put("WirelessGateways", WIRELESS_GATEWAYS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("MulticastGroups", MULTICAST_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkAnalyzerConfigurationRequest, T> g) {
        return obj -> g.apply((CreateNetworkAnalyzerConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String name;
        private TraceContent traceContent;
        private List<String> wirelessDevices = DefaultSdkAutoConstructList.getInstance();
        private List<String> wirelessGateways = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private List<String> multicastGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAnalyzerConfigurationRequest model) {
            super(model);
            this.name(model.name);
            this.traceContent(model.traceContent);
            this.wirelessDevices(model.wirelessDevices);
            this.wirelessGateways(model.wirelessGateways);
            this.description(model.description);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
            this.multicastGroups(model.multicastGroups);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TraceContent.Builder getTraceContent() {
            return this.traceContent != null ? this.traceContent.toBuilder() : null;
        }

        public final void setTraceContent(TraceContent.BuilderImpl traceContent) {
            this.traceContent = traceContent != null ? traceContent.build() : null;
        }

        @Override
        public final Builder traceContent(TraceContent traceContent) {
            this.traceContent = traceContent;
            return this;
        }

        public final Collection<String> getWirelessDevices() {
            if (this.wirelessDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessDevices;
        }

        public final void setWirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
        }

        @Override
        public final Builder wirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevices(String ... wirelessDevices) {
            this.wirelessDevices(Arrays.asList(wirelessDevices));
            return this;
        }

        public final Collection<String> getWirelessGateways() {
            if (this.wirelessGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessGateways;
        }

        public final void setWirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
        }

        @Override
        public final Builder wirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGateways(String ... wirelessGateways) {
            this.wirelessGateways(Arrays.asList(wirelessGateways));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Collection<String> getMulticastGroups() {
            if (this.multicastGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.multicastGroups;
        }

        public final void setMulticastGroups(Collection<String> multicastGroups) {
            this.multicastGroups = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroups);
        }

        @Override
        public final Builder multicastGroups(Collection<String> multicastGroups) {
            this.multicastGroups = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroups(String ... multicastGroups) {
            this.multicastGroups(Arrays.asList(multicastGroups));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkAnalyzerConfigurationRequest build() {
            return new CreateNetworkAnalyzerConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkAnalyzerConfigurationRequest> {
        public Builder name(String var1);

        public Builder traceContent(TraceContent var1);

        default public Builder traceContent(Consumer<TraceContent.Builder> traceContent) {
            return this.traceContent((TraceContent)((TraceContent.Builder)TraceContent.builder().applyMutation(traceContent)).build());
        }

        public Builder wirelessDevices(Collection<String> var1);

        public Builder wirelessDevices(String ... var1);

        public Builder wirelessGateways(Collection<String> var1);

        public Builder wirelessGateways(String ... var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder multicastGroups(Collection<String> var1);

        public Builder multicastGroups(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

