/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANGatewayVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANGatewayVersion> {
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(LoRaWANGatewayVersion.getter(LoRaWANGatewayVersion::packageVersion)).setter(LoRaWANGatewayVersion.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(LoRaWANGatewayVersion.getter(LoRaWANGatewayVersion::model)).setter(LoRaWANGatewayVersion.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Station").getter(LoRaWANGatewayVersion.getter(LoRaWANGatewayVersion::station)).setter(LoRaWANGatewayVersion.setter(Builder::station)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Station").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_FIELD, MODEL_FIELD, STATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoRaWANGatewayVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String packageVersion;
    private final String model;
    private final String station;

    private LoRaWANGatewayVersion(BuilderImpl builder) {
        this.packageVersion = builder.packageVersion;
        this.model = builder.model;
        this.station = builder.station;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String model() {
        return this.model;
    }

    public final String station() {
        return this.station;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.station());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGatewayVersion)) {
            return false;
        }
        LoRaWANGatewayVersion other = (LoRaWANGatewayVersion)obj;
        return Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.station(), other.station());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANGatewayVersion").add("PackageVersion", (Object)this.packageVersion()).add("Model", (Object)this.model()).add("Station", (Object)this.station()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "Station": {
                return Optional.ofNullable(clazz.cast(this.station()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PackageVersion", PACKAGE_VERSION_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("Station", STATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGatewayVersion, T> g) {
        return obj -> g.apply((LoRaWANGatewayVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageVersion;
        private String model;
        private String station;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGatewayVersion model) {
            this.packageVersion(model.packageVersion);
            this.model(model.model);
            this.station(model.station);
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getStation() {
            return this.station;
        }

        public final void setStation(String station) {
            this.station = station;
        }

        @Override
        public final Builder station(String station) {
            this.station = station;
            return this;
        }

        public LoRaWANGatewayVersion build() {
            return new LoRaWANGatewayVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANGatewayVersion> {
        public Builder packageVersion(String var1);

        public Builder model(String var1);

        public Builder station(String var1);
    }
}

