/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANJoinEventNotificationConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JoinEventConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JoinEventConfiguration> {
    private static final SdkField<LoRaWANJoinEventNotificationConfigurations> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(JoinEventConfiguration.getter(JoinEventConfiguration::loRaWAN)).setter(JoinEventConfiguration.setter(Builder::loRaWAN)).constructor(LoRaWANJoinEventNotificationConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<String> WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessDeviceIdEventTopic").getter(JoinEventConfiguration.getter(JoinEventConfiguration::wirelessDeviceIdEventTopicAsString)).setter(JoinEventConfiguration.setter(Builder::wirelessDeviceIdEventTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceIdEventTopic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LO_RA_WAN_FIELD, WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JoinEventConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LoRaWANJoinEventNotificationConfigurations loRaWAN;
    private final String wirelessDeviceIdEventTopic;

    private JoinEventConfiguration(BuilderImpl builder) {
        this.loRaWAN = builder.loRaWAN;
        this.wirelessDeviceIdEventTopic = builder.wirelessDeviceIdEventTopic;
    }

    public final LoRaWANJoinEventNotificationConfigurations loRaWAN() {
        return this.loRaWAN;
    }

    public final EventNotificationTopicStatus wirelessDeviceIdEventTopic() {
        return EventNotificationTopicStatus.fromValue(this.wirelessDeviceIdEventTopic);
    }

    public final String wirelessDeviceIdEventTopicAsString() {
        return this.wirelessDeviceIdEventTopic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessDeviceIdEventTopicAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinEventConfiguration)) {
            return false;
        }
        JoinEventConfiguration other = (JoinEventConfiguration)obj;
        return Objects.equals(this.loRaWAN(), other.loRaWAN()) && Objects.equals(this.wirelessDeviceIdEventTopicAsString(), other.wirelessDeviceIdEventTopicAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JoinEventConfiguration").add("LoRaWAN", (Object)this.loRaWAN()).add("WirelessDeviceIdEventTopic", (Object)this.wirelessDeviceIdEventTopicAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "WirelessDeviceIdEventTopic": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceIdEventTopicAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("WirelessDeviceIdEventTopic", WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JoinEventConfiguration, T> g) {
        return obj -> g.apply((JoinEventConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LoRaWANJoinEventNotificationConfigurations loRaWAN;
        private String wirelessDeviceIdEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinEventConfiguration model) {
            this.loRaWAN(model.loRaWAN);
            this.wirelessDeviceIdEventTopic(model.wirelessDeviceIdEventTopic);
        }

        public final LoRaWANJoinEventNotificationConfigurations.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANJoinEventNotificationConfigurations.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANJoinEventNotificationConfigurations loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getWirelessDeviceIdEventTopic() {
            return this.wirelessDeviceIdEventTopic;
        }

        public final void setWirelessDeviceIdEventTopic(String wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic = wirelessDeviceIdEventTopic;
        }

        @Override
        public final Builder wirelessDeviceIdEventTopic(String wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic = wirelessDeviceIdEventTopic;
            return this;
        }

        @Override
        public final Builder wirelessDeviceIdEventTopic(EventNotificationTopicStatus wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic(wirelessDeviceIdEventTopic == null ? null : wirelessDeviceIdEventTopic.toString());
            return this;
        }

        public JoinEventConfiguration build() {
            return new JoinEventConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JoinEventConfiguration> {
        public Builder loRaWAN(LoRaWANJoinEventNotificationConfigurations var1);

        default public Builder loRaWAN(Consumer<LoRaWANJoinEventNotificationConfigurations.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANJoinEventNotificationConfigurations)((LoRaWANJoinEventNotificationConfigurations.Builder)LoRaWANJoinEventNotificationConfigurations.builder().applyMutation(loRaWAN)).build());
        }

        public Builder wirelessDeviceIdEventTopic(String var1);

        public Builder wirelessDeviceIdEventTopic(EventNotificationTopicStatus var1);
    }
}

