/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterWirelessDeviceRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, DeregisterWirelessDeviceRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(DeregisterWirelessDeviceRequest.getter(DeregisterWirelessDeviceRequest::identifier)).setter(DeregisterWirelessDeviceRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> WIRELESS_DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessDeviceType").getter(DeregisterWirelessDeviceRequest.getter(DeregisterWirelessDeviceRequest::wirelessDeviceTypeAsString)).setter(DeregisterWirelessDeviceRequest.setter(Builder::wirelessDeviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("WirelessDeviceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, WIRELESS_DEVICE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeregisterWirelessDeviceRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String wirelessDeviceType;

    private DeregisterWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.wirelessDeviceType = builder.wirelessDeviceType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final WirelessDeviceType wirelessDeviceType() {
        return WirelessDeviceType.fromValue(this.wirelessDeviceType);
    }

    public final String wirelessDeviceTypeAsString() {
        return this.wirelessDeviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessDeviceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterWirelessDeviceRequest)) {
            return false;
        }
        DeregisterWirelessDeviceRequest other = (DeregisterWirelessDeviceRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.wirelessDeviceTypeAsString(), other.wirelessDeviceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeregisterWirelessDeviceRequest").add("Identifier", (Object)this.identifier()).add("WirelessDeviceType", (Object)this.wirelessDeviceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "WirelessDeviceType": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("WirelessDeviceType", WIRELESS_DEVICE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterWirelessDeviceRequest, T> g) {
        return obj -> g.apply((DeregisterWirelessDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String wirelessDeviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterWirelessDeviceRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.wirelessDeviceType(model.wirelessDeviceType);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getWirelessDeviceType() {
            return this.wirelessDeviceType;
        }

        public final void setWirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
        }

        @Override
        public final Builder wirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
            return this;
        }

        @Override
        public final Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType) {
            this.wirelessDeviceType(wirelessDeviceType == null ? null : wirelessDeviceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterWirelessDeviceRequest build() {
            return new DeregisterWirelessDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterWirelessDeviceRequest> {
        public Builder identifier(String var1);

        public Builder wirelessDeviceType(String var1);

        public Builder wirelessDeviceType(WirelessDeviceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

