/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.LogLevel;
import software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TraceContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TraceContent> {
    private static final SdkField<String> WIRELESS_DEVICE_FRAME_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessDeviceFrameInfo").getter(TraceContent.getter(TraceContent::wirelessDeviceFrameInfoAsString)).setter(TraceContent.setter(Builder::wirelessDeviceFrameInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceFrameInfo").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(TraceContent.getter(TraceContent::logLevelAsString)).setter(TraceContent.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final SdkField<String> MULTICAST_FRAME_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MulticastFrameInfo").getter(TraceContent.getter(TraceContent::multicastFrameInfoAsString)).setter(TraceContent.setter(Builder::multicastFrameInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastFrameInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_DEVICE_FRAME_INFO_FIELD, LOG_LEVEL_FIELD, MULTICAST_FRAME_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TraceContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String wirelessDeviceFrameInfo;
    private final String logLevel;
    private final String multicastFrameInfo;

    private TraceContent(BuilderImpl builder) {
        this.wirelessDeviceFrameInfo = builder.wirelessDeviceFrameInfo;
        this.logLevel = builder.logLevel;
        this.multicastFrameInfo = builder.multicastFrameInfo;
    }

    public final WirelessDeviceFrameInfo wirelessDeviceFrameInfo() {
        return WirelessDeviceFrameInfo.fromValue(this.wirelessDeviceFrameInfo);
    }

    public final String wirelessDeviceFrameInfoAsString() {
        return this.wirelessDeviceFrameInfo;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final MulticastFrameInfo multicastFrameInfo() {
        return MulticastFrameInfo.fromValue(this.multicastFrameInfo);
    }

    public final String multicastFrameInfoAsString() {
        return this.multicastFrameInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessDeviceFrameInfoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastFrameInfoAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceContent)) {
            return false;
        }
        TraceContent other = (TraceContent)obj;
        return Objects.equals(this.wirelessDeviceFrameInfoAsString(), other.wirelessDeviceFrameInfoAsString()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.multicastFrameInfoAsString(), other.multicastFrameInfoAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TraceContent").add("WirelessDeviceFrameInfo", (Object)this.wirelessDeviceFrameInfoAsString()).add("LogLevel", (Object)this.logLevelAsString()).add("MulticastFrameInfo", (Object)this.multicastFrameInfoAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WirelessDeviceFrameInfo": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceFrameInfoAsString()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "MulticastFrameInfo": {
                return Optional.ofNullable(clazz.cast(this.multicastFrameInfoAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WirelessDeviceFrameInfo", WIRELESS_DEVICE_FRAME_INFO_FIELD);
        map.put("LogLevel", LOG_LEVEL_FIELD);
        map.put("MulticastFrameInfo", MULTICAST_FRAME_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TraceContent, T> g) {
        return obj -> g.apply((TraceContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String wirelessDeviceFrameInfo;
        private String logLevel;
        private String multicastFrameInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(TraceContent model) {
            this.wirelessDeviceFrameInfo(model.wirelessDeviceFrameInfo);
            this.logLevel(model.logLevel);
            this.multicastFrameInfo(model.multicastFrameInfo);
        }

        public final String getWirelessDeviceFrameInfo() {
            return this.wirelessDeviceFrameInfo;
        }

        public final void setWirelessDeviceFrameInfo(String wirelessDeviceFrameInfo) {
            this.wirelessDeviceFrameInfo = wirelessDeviceFrameInfo;
        }

        @Override
        public final Builder wirelessDeviceFrameInfo(String wirelessDeviceFrameInfo) {
            this.wirelessDeviceFrameInfo = wirelessDeviceFrameInfo;
            return this;
        }

        @Override
        public final Builder wirelessDeviceFrameInfo(WirelessDeviceFrameInfo wirelessDeviceFrameInfo) {
            this.wirelessDeviceFrameInfo(wirelessDeviceFrameInfo == null ? null : wirelessDeviceFrameInfo.toString());
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getMulticastFrameInfo() {
            return this.multicastFrameInfo;
        }

        public final void setMulticastFrameInfo(String multicastFrameInfo) {
            this.multicastFrameInfo = multicastFrameInfo;
        }

        @Override
        public final Builder multicastFrameInfo(String multicastFrameInfo) {
            this.multicastFrameInfo = multicastFrameInfo;
            return this;
        }

        @Override
        public final Builder multicastFrameInfo(MulticastFrameInfo multicastFrameInfo) {
            this.multicastFrameInfo(multicastFrameInfo == null ? null : multicastFrameInfo.toString());
            return this;
        }

        public TraceContent build() {
            return new TraceContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TraceContent> {
        public Builder wirelessDeviceFrameInfo(String var1);

        public Builder wirelessDeviceFrameInfo(WirelessDeviceFrameInfo var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder multicastFrameInfo(String var1);

        public Builder multicastFrameInfo(MulticastFrameInfo var1);
    }
}

