/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata;
import software.amazon.awssdk.services.iotwireless.model.SidewalkDeviceMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWirelessDeviceStatisticsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetWirelessDeviceStatisticsResponse> {
    private static final SdkField<String> WIRELESS_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessDeviceId").getter(GetWirelessDeviceStatisticsResponse.getter(GetWirelessDeviceStatisticsResponse::wirelessDeviceId)).setter(GetWirelessDeviceStatisticsResponse.setter(Builder::wirelessDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceId").build()}).build();
    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUplinkReceivedAt").getter(GetWirelessDeviceStatisticsResponse.getter(GetWirelessDeviceStatisticsResponse::lastUplinkReceivedAt)).setter(GetWirelessDeviceStatisticsResponse.setter(Builder::lastUplinkReceivedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build()}).build();
    private static final SdkField<LoRaWANDeviceMetadata> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(GetWirelessDeviceStatisticsResponse.getter(GetWirelessDeviceStatisticsResponse::loRaWAN)).setter(GetWirelessDeviceStatisticsResponse.setter(Builder::loRaWAN)).constructor(LoRaWANDeviceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<SidewalkDeviceMetadata> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(GetWirelessDeviceStatisticsResponse.getter(GetWirelessDeviceStatisticsResponse::sidewalk)).setter(GetWirelessDeviceStatisticsResponse.setter(Builder::sidewalk)).constructor(SidewalkDeviceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_DEVICE_ID_FIELD, LAST_UPLINK_RECEIVED_AT_FIELD, LO_RA_WAN_FIELD, SIDEWALK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WirelessDeviceId", WIRELESS_DEVICE_ID_FIELD);
            this.put("LastUplinkReceivedAt", LAST_UPLINK_RECEIVED_AT_FIELD);
            this.put("LoRaWAN", LO_RA_WAN_FIELD);
            this.put("Sidewalk", SIDEWALK_FIELD);
        }
    });
    private final String wirelessDeviceId;
    private final String lastUplinkReceivedAt;
    private final LoRaWANDeviceMetadata loRaWAN;
    private final SidewalkDeviceMetadata sidewalk;

    private GetWirelessDeviceStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessDeviceId = builder.wirelessDeviceId;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
        this.loRaWAN = builder.loRaWAN;
        this.sidewalk = builder.sidewalk;
    }

    public final String wirelessDeviceId() {
        return this.wirelessDeviceId;
    }

    public final String lastUplinkReceivedAt() {
        return this.lastUplinkReceivedAt;
    }

    public final LoRaWANDeviceMetadata loRaWAN() {
        return this.loRaWAN;
    }

    public final SidewalkDeviceMetadata sidewalk() {
        return this.sidewalk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUplinkReceivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessDeviceStatisticsResponse)) {
            return false;
        }
        GetWirelessDeviceStatisticsResponse other = (GetWirelessDeviceStatisticsResponse)((Object)obj);
        return Objects.equals(this.wirelessDeviceId(), other.wirelessDeviceId()) && Objects.equals(this.lastUplinkReceivedAt(), other.lastUplinkReceivedAt()) && Objects.equals(this.loRaWAN(), other.loRaWAN()) && Objects.equals(this.sidewalk(), other.sidewalk());
    }

    public final String toString() {
        return ToString.builder((String)"GetWirelessDeviceStatisticsResponse").add("WirelessDeviceId", (Object)this.wirelessDeviceId()).add("LastUplinkReceivedAt", (Object)this.lastUplinkReceivedAt()).add("LoRaWAN", (Object)this.loRaWAN()).add("Sidewalk", (Object)this.sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WirelessDeviceId": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceId()));
            }
            case "LastUplinkReceivedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUplinkReceivedAt()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessDeviceStatisticsResponse, T> g) {
        return obj -> g.apply((GetWirelessDeviceStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String wirelessDeviceId;
        private String lastUplinkReceivedAt;
        private LoRaWANDeviceMetadata loRaWAN;
        private SidewalkDeviceMetadata sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessDeviceStatisticsResponse model) {
            super(model);
            this.wirelessDeviceId(model.wirelessDeviceId);
            this.lastUplinkReceivedAt(model.lastUplinkReceivedAt);
            this.loRaWAN(model.loRaWAN);
            this.sidewalk(model.sidewalk);
        }

        public final String getWirelessDeviceId() {
            return this.wirelessDeviceId;
        }

        public final void setWirelessDeviceId(String wirelessDeviceId) {
            this.wirelessDeviceId = wirelessDeviceId;
        }

        @Override
        public final Builder wirelessDeviceId(String wirelessDeviceId) {
            this.wirelessDeviceId = wirelessDeviceId;
            return this;
        }

        public final String getLastUplinkReceivedAt() {
            return this.lastUplinkReceivedAt;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final LoRaWANDeviceMetadata.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANDeviceMetadata.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANDeviceMetadata loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final SidewalkDeviceMetadata.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkDeviceMetadata.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkDeviceMetadata sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        @Override
        public GetWirelessDeviceStatisticsResponse build() {
            return new GetWirelessDeviceStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWirelessDeviceStatisticsResponse> {
        public Builder wirelessDeviceId(String var1);

        public Builder lastUplinkReceivedAt(String var1);

        public Builder loRaWAN(LoRaWANDeviceMetadata var1);

        default public Builder loRaWAN(Consumer<LoRaWANDeviceMetadata.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANDeviceMetadata)((LoRaWANDeviceMetadata.Builder)LoRaWANDeviceMetadata.builder().applyMutation(loRaWAN)).build());
        }

        public Builder sidewalk(SidewalkDeviceMetadata var1);

        default public Builder sidewalk(Consumer<SidewalkDeviceMetadata.Builder> sidewalk) {
            return this.sidewalk((SidewalkDeviceMetadata)((SidewalkDeviceMetadata.Builder)SidewalkDeviceMetadata.builder().applyMutation(sidewalk)).build());
        }
    }
}

