/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.JoinResourceTypeEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.ProximityResourceTypeEventConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventConfigurationByResourceTypesResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetEventConfigurationByResourceTypesResponse> {
    private static final SdkField<DeviceRegistrationStateResourceTypeEventConfiguration> DEVICE_REGISTRATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceRegistrationState").getter(GetEventConfigurationByResourceTypesResponse.getter(GetEventConfigurationByResourceTypesResponse::deviceRegistrationState)).setter(GetEventConfigurationByResourceTypesResponse.setter(Builder::deviceRegistrationState)).constructor(DeviceRegistrationStateResourceTypeEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRegistrationState").build()}).build();
    private static final SdkField<ProximityResourceTypeEventConfiguration> PROXIMITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Proximity").getter(GetEventConfigurationByResourceTypesResponse.getter(GetEventConfigurationByResourceTypesResponse::proximity)).setter(GetEventConfigurationByResourceTypesResponse.setter(Builder::proximity)).constructor(ProximityResourceTypeEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proximity").build()}).build();
    private static final SdkField<JoinResourceTypeEventConfiguration> JOIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Join").getter(GetEventConfigurationByResourceTypesResponse.getter(GetEventConfigurationByResourceTypesResponse::join)).setter(GetEventConfigurationByResourceTypesResponse.setter(Builder::join)).constructor(JoinResourceTypeEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Join").build()}).build();
    private static final SdkField<ConnectionStatusResourceTypeEventConfiguration> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionStatus").getter(GetEventConfigurationByResourceTypesResponse.getter(GetEventConfigurationByResourceTypesResponse::connectionStatus)).setter(GetEventConfigurationByResourceTypesResponse.setter(Builder::connectionStatus)).constructor(ConnectionStatusResourceTypeEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<MessageDeliveryStatusResourceTypeEventConfiguration> MESSAGE_DELIVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageDeliveryStatus").getter(GetEventConfigurationByResourceTypesResponse.getter(GetEventConfigurationByResourceTypesResponse::messageDeliveryStatus)).setter(GetEventConfigurationByResourceTypesResponse.setter(Builder::messageDeliveryStatus)).constructor(MessageDeliveryStatusResourceTypeEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDeliveryStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_REGISTRATION_STATE_FIELD, PROXIMITY_FIELD, JOIN_FIELD, CONNECTION_STATUS_FIELD, MESSAGE_DELIVERY_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeviceRegistrationState", DEVICE_REGISTRATION_STATE_FIELD);
            this.put("Proximity", PROXIMITY_FIELD);
            this.put("Join", JOIN_FIELD);
            this.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
            this.put("MessageDeliveryStatus", MESSAGE_DELIVERY_STATUS_FIELD);
        }
    });
    private final DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState;
    private final ProximityResourceTypeEventConfiguration proximity;
    private final JoinResourceTypeEventConfiguration join;
    private final ConnectionStatusResourceTypeEventConfiguration connectionStatus;
    private final MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus;

    private GetEventConfigurationByResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceRegistrationState = builder.deviceRegistrationState;
        this.proximity = builder.proximity;
        this.join = builder.join;
        this.connectionStatus = builder.connectionStatus;
        this.messageDeliveryStatus = builder.messageDeliveryStatus;
    }

    public final DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState() {
        return this.deviceRegistrationState;
    }

    public final ProximityResourceTypeEventConfiguration proximity() {
        return this.proximity;
    }

    public final JoinResourceTypeEventConfiguration join() {
        return this.join;
    }

    public final ConnectionStatusResourceTypeEventConfiguration connectionStatus() {
        return this.connectionStatus;
    }

    public final MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus() {
        return this.messageDeliveryStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRegistrationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.proximity());
        hashCode = 31 * hashCode + Objects.hashCode(this.join());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDeliveryStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventConfigurationByResourceTypesResponse)) {
            return false;
        }
        GetEventConfigurationByResourceTypesResponse other = (GetEventConfigurationByResourceTypesResponse)((Object)obj);
        return Objects.equals(this.deviceRegistrationState(), other.deviceRegistrationState()) && Objects.equals(this.proximity(), other.proximity()) && Objects.equals(this.join(), other.join()) && Objects.equals(this.connectionStatus(), other.connectionStatus()) && Objects.equals(this.messageDeliveryStatus(), other.messageDeliveryStatus());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventConfigurationByResourceTypesResponse").add("DeviceRegistrationState", (Object)this.deviceRegistrationState()).add("Proximity", (Object)this.proximity()).add("Join", (Object)this.join()).add("ConnectionStatus", (Object)this.connectionStatus()).add("MessageDeliveryStatus", (Object)this.messageDeliveryStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceRegistrationState": {
                return Optional.ofNullable(clazz.cast(this.deviceRegistrationState()));
            }
            case "Proximity": {
                return Optional.ofNullable(clazz.cast(this.proximity()));
            }
            case "Join": {
                return Optional.ofNullable(clazz.cast(this.join()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatus()));
            }
            case "MessageDeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.messageDeliveryStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEventConfigurationByResourceTypesResponse, T> g) {
        return obj -> g.apply((GetEventConfigurationByResourceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState;
        private ProximityResourceTypeEventConfiguration proximity;
        private JoinResourceTypeEventConfiguration join;
        private ConnectionStatusResourceTypeEventConfiguration connectionStatus;
        private MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventConfigurationByResourceTypesResponse model) {
            super(model);
            this.deviceRegistrationState(model.deviceRegistrationState);
            this.proximity(model.proximity);
            this.join(model.join);
            this.connectionStatus(model.connectionStatus);
            this.messageDeliveryStatus(model.messageDeliveryStatus);
        }

        public final DeviceRegistrationStateResourceTypeEventConfiguration.Builder getDeviceRegistrationState() {
            return this.deviceRegistrationState != null ? this.deviceRegistrationState.toBuilder() : null;
        }

        public final void setDeviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration.BuilderImpl deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState != null ? deviceRegistrationState.build() : null;
        }

        @Override
        public final Builder deviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            return this;
        }

        public final ProximityResourceTypeEventConfiguration.Builder getProximity() {
            return this.proximity != null ? this.proximity.toBuilder() : null;
        }

        public final void setProximity(ProximityResourceTypeEventConfiguration.BuilderImpl proximity) {
            this.proximity = proximity != null ? proximity.build() : null;
        }

        @Override
        public final Builder proximity(ProximityResourceTypeEventConfiguration proximity) {
            this.proximity = proximity;
            return this;
        }

        public final JoinResourceTypeEventConfiguration.Builder getJoin() {
            return this.join != null ? this.join.toBuilder() : null;
        }

        public final void setJoin(JoinResourceTypeEventConfiguration.BuilderImpl join) {
            this.join = join != null ? join.build() : null;
        }

        @Override
        public final Builder join(JoinResourceTypeEventConfiguration join) {
            this.join = join;
            return this;
        }

        public final ConnectionStatusResourceTypeEventConfiguration.Builder getConnectionStatus() {
            return this.connectionStatus != null ? this.connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(ConnectionStatusResourceTypeEventConfiguration.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatusResourceTypeEventConfiguration connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final MessageDeliveryStatusResourceTypeEventConfiguration.Builder getMessageDeliveryStatus() {
            return this.messageDeliveryStatus != null ? this.messageDeliveryStatus.toBuilder() : null;
        }

        public final void setMessageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration.BuilderImpl messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus != null ? messageDeliveryStatus.build() : null;
        }

        @Override
        public final Builder messageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus;
            return this;
        }

        @Override
        public GetEventConfigurationByResourceTypesResponse build() {
            return new GetEventConfigurationByResourceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventConfigurationByResourceTypesResponse> {
        public Builder deviceRegistrationState(DeviceRegistrationStateResourceTypeEventConfiguration var1);

        default public Builder deviceRegistrationState(Consumer<DeviceRegistrationStateResourceTypeEventConfiguration.Builder> deviceRegistrationState) {
            return this.deviceRegistrationState((DeviceRegistrationStateResourceTypeEventConfiguration)((DeviceRegistrationStateResourceTypeEventConfiguration.Builder)DeviceRegistrationStateResourceTypeEventConfiguration.builder().applyMutation(deviceRegistrationState)).build());
        }

        public Builder proximity(ProximityResourceTypeEventConfiguration var1);

        default public Builder proximity(Consumer<ProximityResourceTypeEventConfiguration.Builder> proximity) {
            return this.proximity((ProximityResourceTypeEventConfiguration)((ProximityResourceTypeEventConfiguration.Builder)ProximityResourceTypeEventConfiguration.builder().applyMutation(proximity)).build());
        }

        public Builder join(JoinResourceTypeEventConfiguration var1);

        default public Builder join(Consumer<JoinResourceTypeEventConfiguration.Builder> join) {
            return this.join((JoinResourceTypeEventConfiguration)((JoinResourceTypeEventConfiguration.Builder)JoinResourceTypeEventConfiguration.builder().applyMutation(join)).build());
        }

        public Builder connectionStatus(ConnectionStatusResourceTypeEventConfiguration var1);

        default public Builder connectionStatus(Consumer<ConnectionStatusResourceTypeEventConfiguration.Builder> connectionStatus) {
            return this.connectionStatus((ConnectionStatusResourceTypeEventConfiguration)((ConnectionStatusResourceTypeEventConfiguration.Builder)ConnectionStatusResourceTypeEventConfiguration.builder().applyMutation(connectionStatus)).build());
        }

        public Builder messageDeliveryStatus(MessageDeliveryStatusResourceTypeEventConfiguration var1);

        default public Builder messageDeliveryStatus(Consumer<MessageDeliveryStatusResourceTypeEventConfiguration.Builder> messageDeliveryStatus) {
            return this.messageDeliveryStatus((MessageDeliveryStatusResourceTypeEventConfiguration)((MessageDeliveryStatusResourceTypeEventConfiguration.Builder)MessageDeliveryStatusResourceTypeEventConfiguration.builder().applyMutation(messageDeliveryStatus)).build());
        }
    }
}

