/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.LogLevel;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOptionListCopier;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLogLevelsByResourceTypesRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, UpdateLogLevelsByResourceTypesRequest> {
    private static final SdkField<String> DEFAULT_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultLogLevel").getter(UpdateLogLevelsByResourceTypesRequest.getter(UpdateLogLevelsByResourceTypesRequest::defaultLogLevelAsString)).setter(UpdateLogLevelsByResourceTypesRequest.setter(Builder::defaultLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultLogLevel").build()}).build();
    private static final SdkField<List<WirelessDeviceLogOption>> WIRELESS_DEVICE_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDeviceLogOptions").getter(UpdateLogLevelsByResourceTypesRequest.getter(UpdateLogLevelsByResourceTypesRequest::wirelessDeviceLogOptions)).setter(UpdateLogLevelsByResourceTypesRequest.setter(Builder::wirelessDeviceLogOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceLogOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WirelessDeviceLogOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WirelessGatewayLogOption>> WIRELESS_GATEWAY_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessGatewayLogOptions").getter(UpdateLogLevelsByResourceTypesRequest.getter(UpdateLogLevelsByResourceTypesRequest::wirelessGatewayLogOptions)).setter(UpdateLogLevelsByResourceTypesRequest.setter(Builder::wirelessGatewayLogOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayLogOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WirelessGatewayLogOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_LOG_LEVEL_FIELD, WIRELESS_DEVICE_LOG_OPTIONS_FIELD, WIRELESS_GATEWAY_LOG_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DefaultLogLevel", DEFAULT_LOG_LEVEL_FIELD);
            this.put("WirelessDeviceLogOptions", WIRELESS_DEVICE_LOG_OPTIONS_FIELD);
            this.put("WirelessGatewayLogOptions", WIRELESS_GATEWAY_LOG_OPTIONS_FIELD);
        }
    });
    private final String defaultLogLevel;
    private final List<WirelessDeviceLogOption> wirelessDeviceLogOptions;
    private final List<WirelessGatewayLogOption> wirelessGatewayLogOptions;

    private UpdateLogLevelsByResourceTypesRequest(BuilderImpl builder) {
        super(builder);
        this.defaultLogLevel = builder.defaultLogLevel;
        this.wirelessDeviceLogOptions = builder.wirelessDeviceLogOptions;
        this.wirelessGatewayLogOptions = builder.wirelessGatewayLogOptions;
    }

    public final LogLevel defaultLogLevel() {
        return LogLevel.fromValue(this.defaultLogLevel);
    }

    public final String defaultLogLevelAsString() {
        return this.defaultLogLevel;
    }

    public final boolean hasWirelessDeviceLogOptions() {
        return this.wirelessDeviceLogOptions != null && !(this.wirelessDeviceLogOptions instanceof SdkAutoConstructList);
    }

    public final List<WirelessDeviceLogOption> wirelessDeviceLogOptions() {
        return this.wirelessDeviceLogOptions;
    }

    public final boolean hasWirelessGatewayLogOptions() {
        return this.wirelessGatewayLogOptions != null && !(this.wirelessGatewayLogOptions instanceof SdkAutoConstructList);
    }

    public final List<WirelessGatewayLogOption> wirelessGatewayLogOptions() {
        return this.wirelessGatewayLogOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDeviceLogOptions() ? this.wirelessDeviceLogOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessGatewayLogOptions() ? this.wirelessGatewayLogOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLogLevelsByResourceTypesRequest)) {
            return false;
        }
        UpdateLogLevelsByResourceTypesRequest other = (UpdateLogLevelsByResourceTypesRequest)((Object)obj);
        return Objects.equals(this.defaultLogLevelAsString(), other.defaultLogLevelAsString()) && this.hasWirelessDeviceLogOptions() == other.hasWirelessDeviceLogOptions() && Objects.equals(this.wirelessDeviceLogOptions(), other.wirelessDeviceLogOptions()) && this.hasWirelessGatewayLogOptions() == other.hasWirelessGatewayLogOptions() && Objects.equals(this.wirelessGatewayLogOptions(), other.wirelessGatewayLogOptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLogLevelsByResourceTypesRequest").add("DefaultLogLevel", (Object)this.defaultLogLevelAsString()).add("WirelessDeviceLogOptions", this.hasWirelessDeviceLogOptions() ? this.wirelessDeviceLogOptions() : null).add("WirelessGatewayLogOptions", this.hasWirelessGatewayLogOptions() ? this.wirelessGatewayLogOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultLogLevel": {
                return Optional.ofNullable(clazz.cast(this.defaultLogLevelAsString()));
            }
            case "WirelessDeviceLogOptions": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceLogOptions()));
            }
            case "WirelessGatewayLogOptions": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewayLogOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLogLevelsByResourceTypesRequest, T> g) {
        return obj -> g.apply((UpdateLogLevelsByResourceTypesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String defaultLogLevel;
        private List<WirelessDeviceLogOption> wirelessDeviceLogOptions = DefaultSdkAutoConstructList.getInstance();
        private List<WirelessGatewayLogOption> wirelessGatewayLogOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLogLevelsByResourceTypesRequest model) {
            super(model);
            this.defaultLogLevel(model.defaultLogLevel);
            this.wirelessDeviceLogOptions(model.wirelessDeviceLogOptions);
            this.wirelessGatewayLogOptions(model.wirelessGatewayLogOptions);
        }

        public final String getDefaultLogLevel() {
            return this.defaultLogLevel;
        }

        public final void setDefaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
        }

        @Override
        public final Builder defaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        @Override
        public final Builder defaultLogLevel(LogLevel defaultLogLevel) {
            this.defaultLogLevel(defaultLogLevel == null ? null : defaultLogLevel.toString());
            return this;
        }

        public final List<WirelessDeviceLogOption.Builder> getWirelessDeviceLogOptions() {
            List<WirelessDeviceLogOption.Builder> result = WirelessDeviceLogOptionListCopier.copyToBuilder(this.wirelessDeviceLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessDeviceLogOptions(Collection<WirelessDeviceLogOption.BuilderImpl> wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions = WirelessDeviceLogOptionListCopier.copyFromBuilder(wirelessDeviceLogOptions);
        }

        @Override
        public final Builder wirelessDeviceLogOptions(Collection<WirelessDeviceLogOption> wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions = WirelessDeviceLogOptionListCopier.copy(wirelessDeviceLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceLogOptions(WirelessDeviceLogOption ... wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions(Arrays.asList(wirelessDeviceLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceLogOptions(Consumer<WirelessDeviceLogOption.Builder> ... wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions(Stream.of(wirelessDeviceLogOptions).map(c -> (WirelessDeviceLogOption)((WirelessDeviceLogOption.Builder)WirelessDeviceLogOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WirelessGatewayLogOption.Builder> getWirelessGatewayLogOptions() {
            List<WirelessGatewayLogOption.Builder> result = WirelessGatewayLogOptionListCopier.copyToBuilder(this.wirelessGatewayLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessGatewayLogOptions(Collection<WirelessGatewayLogOption.BuilderImpl> wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions = WirelessGatewayLogOptionListCopier.copyFromBuilder(wirelessGatewayLogOptions);
        }

        @Override
        public final Builder wirelessGatewayLogOptions(Collection<WirelessGatewayLogOption> wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions = WirelessGatewayLogOptionListCopier.copy(wirelessGatewayLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayLogOptions(WirelessGatewayLogOption ... wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions(Arrays.asList(wirelessGatewayLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayLogOptions(Consumer<WirelessGatewayLogOption.Builder> ... wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions(Stream.of(wirelessGatewayLogOptions).map(c -> (WirelessGatewayLogOption)((WirelessGatewayLogOption.Builder)WirelessGatewayLogOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLogLevelsByResourceTypesRequest build() {
            return new UpdateLogLevelsByResourceTypesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLogLevelsByResourceTypesRequest> {
        public Builder defaultLogLevel(String var1);

        public Builder defaultLogLevel(LogLevel var1);

        public Builder wirelessDeviceLogOptions(Collection<WirelessDeviceLogOption> var1);

        public Builder wirelessDeviceLogOptions(WirelessDeviceLogOption ... var1);

        public Builder wirelessDeviceLogOptions(Consumer<WirelessDeviceLogOption.Builder> ... var1);

        public Builder wirelessGatewayLogOptions(Collection<WirelessGatewayLogOption> var1);

        public Builder wirelessGatewayLogOptions(WirelessGatewayLogOption ... var1);

        public Builder wirelessGatewayLogOptions(Consumer<WirelessGatewayLogOption.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

