/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse;

public class ListMulticastGroupsIterable
implements SdkIterable<ListMulticastGroupsResponse> {
    private final IotWirelessClient client;
    private final ListMulticastGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMulticastGroupsIterable(IotWirelessClient client, ListMulticastGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMulticastGroupsResponseFetcher();
    }

    public Iterator<ListMulticastGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMulticastGroupsResponseFetcher
    implements SyncPageFetcher<ListMulticastGroupsResponse> {
        private ListMulticastGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListMulticastGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMulticastGroupsResponse nextPage(ListMulticastGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListMulticastGroupsIterable.this.client.listMulticastGroups(ListMulticastGroupsIterable.this.firstRequest);
            }
            return ListMulticastGroupsIterable.this.client.listMulticastGroups((ListMulticastGroupsRequest)((Object)ListMulticastGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

