/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;

public class ListWirelessGatewaysIterable
implements SdkIterable<ListWirelessGatewaysResponse> {
    private final IotWirelessClient client;
    private final ListWirelessGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWirelessGatewaysIterable(IotWirelessClient client, ListWirelessGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWirelessGatewaysResponseFetcher();
    }

    public Iterator<ListWirelessGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWirelessGatewaysResponseFetcher
    implements SyncPageFetcher<ListWirelessGatewaysResponse> {
        private ListWirelessGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListWirelessGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWirelessGatewaysResponse nextPage(ListWirelessGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListWirelessGatewaysIterable.this.client.listWirelessGateways(ListWirelessGatewaysIterable.this.firstRequest);
            }
            return ListWirelessGatewaysIterable.this.client.listWirelessGateways((ListWirelessGatewaysRequest)((Object)ListWirelessGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

