/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWANGateway object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANGateway implements SdkPojo, Serializable, ToCopyableBuilder<LoRaWANGateway.Builder, LoRaWANGateway> {
    private static final SdkField<String> GATEWAY_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayEui").getter(getter(LoRaWANGateway::gatewayEui)).setter(setter(Builder::gatewayEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayEui").build()).build();

    private static final SdkField<String> RF_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RfRegion").getter(getter(LoRaWANGateway::rfRegion)).setter(setter(Builder::rfRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_EUI_FIELD,
            RF_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gatewayEui;

    private final String rfRegion;

    private LoRaWANGateway(BuilderImpl builder) {
        this.gatewayEui = builder.gatewayEui;
        this.rfRegion = builder.rfRegion;
    }

    /**
     * <p>
     * The gateway's EUI value.
     * </p>
     * 
     * @return The gateway's EUI value.
     */
    public final String gatewayEui() {
        return gatewayEui;
    }

    /**
     * <p>
     * The frequency band (RFRegion) value.
     * </p>
     * 
     * @return The frequency band (RFRegion) value.
     */
    public final String rfRegion() {
        return rfRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayEui());
        hashCode = 31 * hashCode + Objects.hashCode(rfRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGateway)) {
            return false;
        }
        LoRaWANGateway other = (LoRaWANGateway) obj;
        return Objects.equals(gatewayEui(), other.gatewayEui()) && Objects.equals(rfRegion(), other.rfRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANGateway").add("GatewayEui", gatewayEui()).add("RfRegion", rfRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayEui":
            return Optional.ofNullable(clazz.cast(gatewayEui()));
        case "RfRegion":
            return Optional.ofNullable(clazz.cast(rfRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGateway, T> g) {
        return obj -> g.apply((LoRaWANGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANGateway> {
        /**
         * <p>
         * The gateway's EUI value.
         * </p>
         * 
         * @param gatewayEui
         *        The gateway's EUI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayEui(String gatewayEui);

        /**
         * <p>
         * The frequency band (RFRegion) value.
         * </p>
         * 
         * @param rfRegion
         *        The frequency band (RFRegion) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rfRegion(String rfRegion);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayEui;

        private String rfRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGateway model) {
            gatewayEui(model.gatewayEui);
            rfRegion(model.rfRegion);
        }

        public final String getGatewayEui() {
            return gatewayEui;
        }

        @Override
        public final Builder gatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
            return this;
        }

        public final void setGatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
        }

        public final String getRfRegion() {
            return rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public LoRaWANGateway build() {
            return new LoRaWANGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
