/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessDeviceStatisticsResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetWirelessDeviceStatisticsResponse.Builder, GetWirelessDeviceStatisticsResponse> {
    private static final SdkField<String> WIRELESS_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WirelessDeviceId").getter(getter(GetWirelessDeviceStatisticsResponse::wirelessDeviceId))
            .setter(setter(Builder::wirelessDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceId").build()).build();

    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUplinkReceivedAt").getter(getter(GetWirelessDeviceStatisticsResponse::lastUplinkReceivedAt))
            .setter(setter(Builder::lastUplinkReceivedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build())
            .build();

    private static final SdkField<LoRaWANDeviceMetadata> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANDeviceMetadata> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(GetWirelessDeviceStatisticsResponse::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANDeviceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_DEVICE_ID_FIELD,
            LAST_UPLINK_RECEIVED_AT_FIELD, LO_RA_WAN_FIELD));

    private final String wirelessDeviceId;

    private final String lastUplinkReceivedAt;

    private final LoRaWANDeviceMetadata loRaWAN;

    private GetWirelessDeviceStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessDeviceId = builder.wirelessDeviceId;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
        this.loRaWAN = builder.loRaWAN;
    }

    /**
     * <p>
     * The ID of the wireless device.
     * </p>
     * 
     * @return The ID of the wireless device.
     */
    public final String wirelessDeviceId() {
        return wirelessDeviceId;
    }

    /**
     * <p>
     * The date and time when the most recent uplink was received.
     * </p>
     * 
     * @return The date and time when the most recent uplink was received.
     */
    public final String lastUplinkReceivedAt() {
        return lastUplinkReceivedAt;
    }

    /**
     * <p>
     * Information about the wireless device's operations.
     * </p>
     * 
     * @return Information about the wireless device's operations.
     */
    public final LoRaWANDeviceMetadata loRaWAN() {
        return loRaWAN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(wirelessDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUplinkReceivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessDeviceStatisticsResponse)) {
            return false;
        }
        GetWirelessDeviceStatisticsResponse other = (GetWirelessDeviceStatisticsResponse) obj;
        return Objects.equals(wirelessDeviceId(), other.wirelessDeviceId())
                && Objects.equals(lastUplinkReceivedAt(), other.lastUplinkReceivedAt())
                && Objects.equals(loRaWAN(), other.loRaWAN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessDeviceStatisticsResponse").add("WirelessDeviceId", wirelessDeviceId())
                .add("LastUplinkReceivedAt", lastUplinkReceivedAt()).add("LoRaWAN", loRaWAN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WirelessDeviceId":
            return Optional.ofNullable(clazz.cast(wirelessDeviceId()));
        case "LastUplinkReceivedAt":
            return Optional.ofNullable(clazz.cast(lastUplinkReceivedAt()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessDeviceStatisticsResponse, T> g) {
        return obj -> g.apply((GetWirelessDeviceStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWirelessDeviceStatisticsResponse> {
        /**
         * <p>
         * The ID of the wireless device.
         * </p>
         * 
         * @param wirelessDeviceId
         *        The ID of the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDeviceId(String wirelessDeviceId);

        /**
         * <p>
         * The date and time when the most recent uplink was received.
         * </p>
         * 
         * @param lastUplinkReceivedAt
         *        The date and time when the most recent uplink was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUplinkReceivedAt(String lastUplinkReceivedAt);

        /**
         * <p>
         * Information about the wireless device's operations.
         * </p>
         * 
         * @param loRaWAN
         *        Information about the wireless device's operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANDeviceMetadata loRaWAN);

        /**
         * <p>
         * Information about the wireless device's operations.
         * </p>
         * This is a convenience that creates an instance of the {@link LoRaWANDeviceMetadata.Builder} avoiding the need
         * to create one manually via {@link LoRaWANDeviceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANDeviceMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #loRaWAN(LoRaWANDeviceMetadata)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANDeviceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANDeviceMetadata)
         */
        default Builder loRaWAN(Consumer<LoRaWANDeviceMetadata.Builder> loRaWAN) {
            return loRaWAN(LoRaWANDeviceMetadata.builder().applyMutation(loRaWAN).build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String wirelessDeviceId;

        private String lastUplinkReceivedAt;

        private LoRaWANDeviceMetadata loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessDeviceStatisticsResponse model) {
            super(model);
            wirelessDeviceId(model.wirelessDeviceId);
            lastUplinkReceivedAt(model.lastUplinkReceivedAt);
            loRaWAN(model.loRaWAN);
        }

        public final String getWirelessDeviceId() {
            return wirelessDeviceId;
        }

        @Override
        public final Builder wirelessDeviceId(String wirelessDeviceId) {
            this.wirelessDeviceId = wirelessDeviceId;
            return this;
        }

        public final void setWirelessDeviceId(String wirelessDeviceId) {
            this.wirelessDeviceId = wirelessDeviceId;
        }

        public final String getLastUplinkReceivedAt() {
            return lastUplinkReceivedAt;
        }

        @Override
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        public final LoRaWANDeviceMetadata.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANDeviceMetadata loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final void setLoRaWAN(LoRaWANDeviceMetadata.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public GetWirelessDeviceStatisticsResponse build() {
            return new GetWirelessDeviceStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
