/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateWirelessDeviceWithThingRequest extends IotWirelessRequest implements
        ToCopyableBuilder<AssociateWirelessDeviceWithThingRequest.Builder, AssociateWirelessDeviceWithThingRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AssociateWirelessDeviceWithThingRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThingArn").getter(getter(AssociateWirelessDeviceWithThingRequest::thingArn))
            .setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, THING_ARN_FIELD));

    private final String id;

    private final String thingArn;

    private AssociateWirelessDeviceWithThingRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.thingArn = builder.thingArn;
    }

    /**
     * <p>
     * The ID of the resource to update.
     * </p>
     * 
     * @return The ID of the resource to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the thing to associate with the wireless device.
     * </p>
     * 
     * @return The ARN of the thing to associate with the wireless device.
     */
    public final String thingArn() {
        return thingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWirelessDeviceWithThingRequest)) {
            return false;
        }
        AssociateWirelessDeviceWithThingRequest other = (AssociateWirelessDeviceWithThingRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(thingArn(), other.thingArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateWirelessDeviceWithThingRequest").add("Id", id()).add("ThingArn", thingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ThingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateWirelessDeviceWithThingRequest, T> g) {
        return obj -> g.apply((AssociateWirelessDeviceWithThingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateWirelessDeviceWithThingRequest> {
        /**
         * <p>
         * The ID of the resource to update.
         * </p>
         * 
         * @param id
         *        The ID of the resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the thing to associate with the wireless device.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing to associate with the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String id;

        private String thingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWirelessDeviceWithThingRequest model) {
            super(model);
            id(model.id);
            thingArn(model.thingArn);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getThingArn() {
            return thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateWirelessDeviceWithThingRequest build() {
            return new AssociateWirelessDeviceWithThingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
