/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAwsAccountWithPartnerAccountResponse extends IotWirelessResponse implements
        ToCopyableBuilder<AssociateAwsAccountWithPartnerAccountResponse.Builder, AssociateAwsAccountWithPartnerAccountResponse> {
    private static final SdkField<SidewalkAccountInfo> SIDEWALK_FIELD = SdkField
            .<SidewalkAccountInfo> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(AssociateAwsAccountWithPartnerAccountResponse::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkAccountInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD));

    private final SidewalkAccountInfo sidewalk;

    private AssociateAwsAccountWithPartnerAccountResponse(BuilderImpl builder) {
        super(builder);
        this.sidewalk = builder.sidewalk;
    }

    /**
     * <p>
     * The Sidewalk account credentials.
     * </p>
     * 
     * @return The Sidewalk account credentials.
     */
    public final SidewalkAccountInfo sidewalk() {
        return sidewalk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAwsAccountWithPartnerAccountResponse)) {
            return false;
        }
        AssociateAwsAccountWithPartnerAccountResponse other = (AssociateAwsAccountWithPartnerAccountResponse) obj;
        return Objects.equals(sidewalk(), other.sidewalk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAwsAccountWithPartnerAccountResponse").add("Sidewalk", sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAwsAccountWithPartnerAccountResponse, T> g) {
        return obj -> g.apply((AssociateAwsAccountWithPartnerAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateAwsAccountWithPartnerAccountResponse> {
        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * 
         * @param sidewalk
         *        The Sidewalk account credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkAccountInfo sidewalk);

        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * This is a convenience that creates an instance of the {@link SidewalkAccountInfo.Builder} avoiding the need
         * to create one manually via {@link SidewalkAccountInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link SidewalkAccountInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #sidewalk(SidewalkAccountInfo)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkAccountInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkAccountInfo)
         */
        default Builder sidewalk(Consumer<SidewalkAccountInfo.Builder> sidewalk) {
            return sidewalk(SidewalkAccountInfo.builder().applyMutation(sidewalk).build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private SidewalkAccountInfo sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAwsAccountWithPartnerAccountResponse model) {
            super(model);
            sidewalk(model.sidewalk);
        }

        public final SidewalkAccountInfo.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkAccountInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final void setSidewalk(SidewalkAccountInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public AssociateAwsAccountWithPartnerAccountResponse build() {
            return new AssociateAwsAccountWithPartnerAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
