/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotwireless.model.AccessDeniedException;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.ConflictException;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.InternalServerException;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessException;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;
import software.amazon.awssdk.services.iotwireless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.TagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.TagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.ThrottlingException;
import software.amazon.awssdk.services.iotwireless.model.TooManyTagsException;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.ValidationException;
import software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable;

/**
 * Service client for accessing AWS IoT Wireless. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS IoT Wireless API documentation
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface IotWirelessClient extends SdkClient {
    String SERVICE_NAME = "iotwireless";

    /**
     * Create a {@link IotWirelessClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotWirelessClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotWirelessClient}.
     */
    static IotWirelessClientBuilder builder() {
        return new DefaultIotWirelessClientBuilder();
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     * @return Result of the AssociateAwsAccountWithPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAwsAccountWithPartnerAccountResponse associateAwsAccountWithPartnerAccount(
            AssociateAwsAccountWithPartnerAccountRequest associateAwsAccountWithPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateAwsAccountWithPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateAwsAccountWithPartnerAccountRequest#builder()}
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAwsAccountWithPartnerAccountRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateAwsAccountWithPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAwsAccountWithPartnerAccountResponse associateAwsAccountWithPartnerAccount(
            Consumer<AssociateAwsAccountWithPartnerAccountRequest.Builder> associateAwsAccountWithPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateAwsAccountWithPartnerAccount(AssociateAwsAccountWithPartnerAccountRequest.builder()
                .applyMutation(associateAwsAccountWithPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     * @return Result of the AssociateWirelessDeviceWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithThingResponse associateWirelessDeviceWithThing(
            AssociateWirelessDeviceWithThingRequest associateWirelessDeviceWithThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessDeviceWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessDeviceWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessDeviceWithThingRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateWirelessDeviceWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessDeviceWithThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessDeviceWithThingResponse associateWirelessDeviceWithThing(
            Consumer<AssociateWirelessDeviceWithThingRequest.Builder> associateWirelessDeviceWithThingRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessDeviceWithThing(AssociateWirelessDeviceWithThingRequest.builder()
                .applyMutation(associateWirelessDeviceWithThingRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     * @return Result of the AssociateWirelessGatewayWithCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithCertificateResponse associateWirelessGatewayWithCertificate(
            AssociateWirelessGatewayWithCertificateRequest associateWirelessGatewayWithCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessGatewayWithCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessGatewayWithCertificateRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateWirelessGatewayWithCertificateRequest.Builder} to create a request.
     * @return Result of the AssociateWirelessGatewayWithCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithCertificateResponse associateWirelessGatewayWithCertificate(
            Consumer<AssociateWirelessGatewayWithCertificateRequest.Builder> associateWirelessGatewayWithCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessGatewayWithCertificate(AssociateWirelessGatewayWithCertificateRequest.builder()
                .applyMutation(associateWirelessGatewayWithCertificateRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     * @return Result of the AssociateWirelessGatewayWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithThingResponse associateWirelessGatewayWithThing(
            AssociateWirelessGatewayWithThingRequest associateWirelessGatewayWithThingRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessGatewayWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessGatewayWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessGatewayWithThingRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateWirelessGatewayWithThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.AssociateWirelessGatewayWithThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWirelessGatewayWithThingResponse associateWirelessGatewayWithThing(
            Consumer<AssociateWirelessGatewayWithThingRequest.Builder> associateWirelessGatewayWithThingRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return associateWirelessGatewayWithThing(AssociateWirelessGatewayWithThingRequest.builder()
                .applyMutation(associateWirelessGatewayWithThingRequest).build());
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     *
     * @param createDestinationRequest
     * @return Result of the CreateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDestinationResponse createDestination(CreateDestinationRequest createDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDestinationRequest#builder()}
     * </p>
     *
     * @param createDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDestinationRequest.Builder} to create a request.
     * @return Result of the CreateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDestinationResponse createDestination(Consumer<CreateDestinationRequest.Builder> createDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return createDestination(CreateDestinationRequest.builder().applyMutation(createDestinationRequest).build());
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     *
     * @param createDeviceProfileRequest
     * @return Result of the CreateDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDeviceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceProfileResponse createDeviceProfile(CreateDeviceProfileRequest createDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeviceProfileRequest#builder()}
     * </p>
     *
     * @param createDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateDeviceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceProfileResponse createDeviceProfile(
            Consumer<CreateDeviceProfileRequest.Builder> createDeviceProfileRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return createDeviceProfile(CreateDeviceProfileRequest.builder().applyMutation(createDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     *
     * @param createServiceProfileRequest
     * @return Result of the CreateServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateServiceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceProfileResponse createServiceProfile(CreateServiceProfileRequest createServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceProfileRequest#builder()}
     * </p>
     *
     * @param createServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateServiceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateServiceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceProfileResponse createServiceProfile(
            Consumer<CreateServiceProfileRequest.Builder> createServiceProfileRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return createServiceProfile(CreateServiceProfileRequest.builder().applyMutation(createServiceProfileRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     *
     * @param createWirelessDeviceRequest
     * @return Result of the CreateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessDeviceResponse createWirelessDevice(CreateWirelessDeviceRequest createWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param createWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessDeviceResponse createWirelessDevice(
            Consumer<CreateWirelessDeviceRequest.Builder> createWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return createWirelessDevice(CreateWirelessDeviceRequest.builder().applyMutation(createWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayRequest
     * @return Result of the CreateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayResponse createWirelessGateway(CreateWirelessGatewayRequest createWirelessGatewayRequest)
            throws ValidationException, AccessDeniedException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayResponse createWirelessGateway(
            Consumer<CreateWirelessGatewayRequest.Builder> createWirelessGatewayRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return createWirelessGateway(CreateWirelessGatewayRequest.builder().applyMutation(createWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     * @return Result of the CreateWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskResponse createWirelessGatewayTask(
            CreateWirelessGatewayTaskRequest createWirelessGatewayTaskRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskResponse createWirelessGatewayTask(
            Consumer<CreateWirelessGatewayTaskRequest.Builder> createWirelessGatewayTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return createWirelessGatewayTask(CreateWirelessGatewayTaskRequest.builder()
                .applyMutation(createWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     * @return Result of the CreateWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskDefinitionResponse createWirelessGatewayTaskDefinition(
            CreateWirelessGatewayTaskDefinitionRequest createWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWirelessGatewayTaskDefinitionResponse createWirelessGatewayTaskDefinition(
            Consumer<CreateWirelessGatewayTaskDefinitionRequest.Builder> createWirelessGatewayTaskDefinitionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return createWirelessGatewayTaskDefinition(CreateWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(createWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDestinationResponse deleteDestination(DeleteDestinationRequest deleteDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDestinationRequest.Builder} to create a request.
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDestinationResponse deleteDestination(Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     *
     * @param deleteDeviceProfileRequest
     * @return Result of the DeleteDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDeviceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceProfileResponse deleteDeviceProfile(DeleteDeviceProfileRequest deleteDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceProfileRequest#builder()}
     * </p>
     *
     * @param deleteDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteDeviceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceProfileResponse deleteDeviceProfile(
            Consumer<DeleteDeviceProfileRequest.Builder> deleteDeviceProfileRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return deleteDeviceProfile(DeleteDeviceProfileRequest.builder().applyMutation(deleteDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     *
     * @param deleteServiceProfileRequest
     * @return Result of the DeleteServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteServiceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceProfileResponse deleteServiceProfile(DeleteServiceProfileRequest deleteServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceProfileRequest#builder()}
     * </p>
     *
     * @param deleteServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServiceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteServiceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceProfileResponse deleteServiceProfile(
            Consumer<DeleteServiceProfileRequest.Builder> deleteServiceProfileRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return deleteServiceProfile(DeleteServiceProfileRequest.builder().applyMutation(deleteServiceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     * @return Result of the DeleteWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessDeviceResponse deleteWirelessDevice(DeleteWirelessDeviceRequest deleteWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessDeviceResponse deleteWirelessDevice(
            Consumer<DeleteWirelessDeviceRequest.Builder> deleteWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return deleteWirelessDevice(DeleteWirelessDeviceRequest.builder().applyMutation(deleteWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     * @return Result of the DeleteWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayResponse deleteWirelessGateway(DeleteWirelessGatewayRequest deleteWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayResponse deleteWirelessGateway(
            Consumer<DeleteWirelessGatewayRequest.Builder> deleteWirelessGatewayRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return deleteWirelessGateway(DeleteWirelessGatewayRequest.builder().applyMutation(deleteWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     * @return Result of the DeleteWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskResponse deleteWirelessGatewayTask(
            DeleteWirelessGatewayTaskRequest deleteWirelessGatewayTaskRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskResponse deleteWirelessGatewayTask(
            Consumer<DeleteWirelessGatewayTaskRequest.Builder> deleteWirelessGatewayTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return deleteWirelessGatewayTask(DeleteWirelessGatewayTaskRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     * @return Result of the DeleteWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskDefinitionResponse deleteWirelessGatewayTaskDefinition(
            DeleteWirelessGatewayTaskDefinitionRequest deleteWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWirelessGatewayTaskDefinitionResponse deleteWirelessGatewayTaskDefinition(
            Consumer<DeleteWirelessGatewayTaskDefinitionRequest.Builder> deleteWirelessGatewayTaskDefinitionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return deleteWirelessGatewayTaskDefinition(DeleteWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     * @return Result of the DisassociateAwsAccountFromPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAwsAccountFromPartnerAccountResponse disassociateAwsAccountFromPartnerAccount(
            DisassociateAwsAccountFromPartnerAccountRequest disassociateAwsAccountFromPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateAwsAccountFromPartnerAccountRequest#builder()}
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} to create a request.
     * @return Result of the DisassociateAwsAccountFromPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAwsAccountFromPartnerAccountResponse disassociateAwsAccountFromPartnerAccount(
            Consumer<DisassociateAwsAccountFromPartnerAccountRequest.Builder> disassociateAwsAccountFromPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateAwsAccountFromPartnerAccount(DisassociateAwsAccountFromPartnerAccountRequest.builder()
                .applyMutation(disassociateAwsAccountFromPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     * @return Result of the DisassociateWirelessDeviceFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromThingResponse disassociateWirelessDeviceFromThing(
            DisassociateWirelessDeviceFromThingRequest disassociateWirelessDeviceFromThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWirelessDeviceFromThingRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWirelessDeviceFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessDeviceFromThingRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateWirelessDeviceFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessDeviceFromThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessDeviceFromThingResponse disassociateWirelessDeviceFromThing(
            Consumer<DisassociateWirelessDeviceFromThingRequest.Builder> disassociateWirelessDeviceFromThingRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessDeviceFromThing(DisassociateWirelessDeviceFromThingRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromThingRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     * @return Result of the DisassociateWirelessGatewayFromCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromCertificateResponse disassociateWirelessGatewayFromCertificate(
            DisassociateWirelessGatewayFromCertificateRequest disassociateWirelessGatewayFromCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromCertificateRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} to create a request.
     * @return Result of the DisassociateWirelessGatewayFromCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromCertificateResponse disassociateWirelessGatewayFromCertificate(
            Consumer<DisassociateWirelessGatewayFromCertificateRequest.Builder> disassociateWirelessGatewayFromCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessGatewayFromCertificate(DisassociateWirelessGatewayFromCertificateRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromCertificateRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     * @return Result of the DisassociateWirelessGatewayFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromThingResponse disassociateWirelessGatewayFromThing(
            DisassociateWirelessGatewayFromThingRequest disassociateWirelessGatewayFromThingRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromThingRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessGatewayFromThingRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateWirelessGatewayFromThing operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.DisassociateWirelessGatewayFromThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWirelessGatewayFromThingResponse disassociateWirelessGatewayFromThing(
            Consumer<DisassociateWirelessGatewayFromThingRequest.Builder> disassociateWirelessGatewayFromThingRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotWirelessException {
        return disassociateWirelessGatewayFromThing(DisassociateWirelessGatewayFromThingRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromThingRequest).build());
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     *
     * @param getDestinationRequest
     * @return Result of the GetDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDestinationResponse getDestination(GetDestinationRequest getDestinationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link GetDestinationRequest#builder()}
     * </p>
     *
     * @param getDestinationRequest
     *        A {@link Consumer} that will call methods on {@link GetDestinationRequest.Builder} to create a request.
     * @return Result of the GetDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDestinationResponse getDestination(Consumer<GetDestinationRequest.Builder> getDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getDestination(GetDestinationRequest.builder().applyMutation(getDestinationRequest).build());
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     *
     * @param getDeviceProfileRequest
     * @return Result of the GetDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDeviceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceProfileResponse getDeviceProfile(GetDeviceProfileRequest getDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceProfileRequest#builder()}
     * </p>
     *
     * @param getDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceProfileRequest.Builder} to create a request.
     * @return Result of the GetDeviceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetDeviceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceProfileResponse getDeviceProfile(Consumer<GetDeviceProfileRequest.Builder> getDeviceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getDeviceProfile(GetDeviceProfileRequest.builder().applyMutation(getDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     *
     * @param getPartnerAccountRequest
     * @return Result of the GetPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPartnerAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPartnerAccountResponse getPartnerAccount(GetPartnerAccountRequest getPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartnerAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetPartnerAccountRequest#builder()}
     * </p>
     *
     * @param getPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetPartnerAccountRequest.Builder} to create a request.
     * @return Result of the GetPartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetPartnerAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPartnerAccountResponse getPartnerAccount(Consumer<GetPartnerAccountRequest.Builder> getPartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return getPartnerAccount(GetPartnerAccountRequest.builder().applyMutation(getPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     *
     * @param getServiceEndpointRequest
     * @return Result of the GetServiceEndpoint operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceEndpointResponse getServiceEndpoint(GetServiceEndpointRequest getServiceEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceEndpointRequest#builder()}
     * </p>
     *
     * @param getServiceEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceEndpoint operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceEndpointResponse getServiceEndpoint(Consumer<GetServiceEndpointRequest.Builder> getServiceEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getServiceEndpoint(GetServiceEndpointRequest.builder().applyMutation(getServiceEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     *
     * @param getServiceProfileRequest
     * @return Result of the GetServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceProfileResponse getServiceProfile(GetServiceProfileRequest getServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceProfileRequest#builder()}
     * </p>
     *
     * @param getServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceProfileRequest.Builder} to create a request.
     * @return Result of the GetServiceProfile operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetServiceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceProfileResponse getServiceProfile(Consumer<GetServiceProfileRequest.Builder> getServiceProfileRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getServiceProfile(GetServiceProfileRequest.builder().applyMutation(getServiceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceRequest
     * @return Result of the GetWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWirelessDeviceResponse getWirelessDevice(GetWirelessDeviceRequest getWirelessDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link GetWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceRequest.Builder} to create a request.
     * @return Result of the GetWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWirelessDeviceResponse getWirelessDevice(Consumer<GetWirelessDeviceRequest.Builder> getWirelessDeviceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessDevice(GetWirelessDeviceRequest.builder().applyMutation(getWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     * @return Result of the GetWirelessDeviceStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDeviceStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessDeviceStatisticsResponse getWirelessDeviceStatistics(
            GetWirelessDeviceStatisticsRequest getWirelessDeviceStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessDeviceStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceStatisticsRequest.Builder} to create
     *        a request.
     * @return Result of the GetWirelessDeviceStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessDeviceStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessDeviceStatisticsResponse getWirelessDeviceStatistics(
            Consumer<GetWirelessDeviceStatisticsRequest.Builder> getWirelessDeviceStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getWirelessDeviceStatistics(GetWirelessDeviceStatisticsRequest.builder()
                .applyMutation(getWirelessDeviceStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayRequest
     * @return Result of the GetWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWirelessGatewayResponse getWirelessGateway(GetWirelessGatewayRequest getWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the GetWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWirelessGatewayResponse getWirelessGateway(Consumer<GetWirelessGatewayRequest.Builder> getWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGateway(GetWirelessGatewayRequest.builder().applyMutation(getWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     * @return Result of the GetWirelessGatewayCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayCertificateResponse getWirelessGatewayCertificate(
            GetWirelessGatewayCertificateRequest getWirelessGatewayCertificateRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayCertificateRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayCertificateRequest.Builder} to
     *        create a request.
     * @return Result of the GetWirelessGatewayCertificate operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayCertificateResponse getWirelessGatewayCertificate(
            Consumer<GetWirelessGatewayCertificateRequest.Builder> getWirelessGatewayCertificateRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayCertificate(GetWirelessGatewayCertificateRequest.builder()
                .applyMutation(getWirelessGatewayCertificateRequest).build());
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     * @return Result of the GetWirelessGatewayFirmwareInformation operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayFirmwareInformationResponse getWirelessGatewayFirmwareInformation(
            GetWirelessGatewayFirmwareInformationRequest getWirelessGatewayFirmwareInformationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetWirelessGatewayFirmwareInformationRequest.Builder} avoiding the need to create one manually via
     * {@link GetWirelessGatewayFirmwareInformationRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayFirmwareInformationRequest.Builder}
     *        to create a request.
     * @return Result of the GetWirelessGatewayFirmwareInformation operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayFirmwareInformationResponse getWirelessGatewayFirmwareInformation(
            Consumer<GetWirelessGatewayFirmwareInformationRequest.Builder> getWirelessGatewayFirmwareInformationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayFirmwareInformation(GetWirelessGatewayFirmwareInformationRequest.builder()
                .applyMutation(getWirelessGatewayFirmwareInformationRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     * @return Result of the GetWirelessGatewayStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayStatisticsResponse getWirelessGatewayStatistics(
            GetWirelessGatewayStatisticsRequest getWirelessGatewayStatisticsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayStatisticsRequest.Builder} to create
     *        a request.
     * @return Result of the GetWirelessGatewayStatistics operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayStatisticsResponse getWirelessGatewayStatistics(
            Consumer<GetWirelessGatewayStatisticsRequest.Builder> getWirelessGatewayStatisticsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayStatistics(GetWirelessGatewayStatisticsRequest.builder()
                .applyMutation(getWirelessGatewayStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     * @return Result of the GetWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskResponse getWirelessGatewayTask(GetWirelessGatewayTaskRequest getWirelessGatewayTaskRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return Result of the GetWirelessGatewayTask operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskResponse getWirelessGatewayTask(
            Consumer<GetWirelessGatewayTaskRequest.Builder> getWirelessGatewayTaskRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return getWirelessGatewayTask(GetWirelessGatewayTaskRequest.builder().applyMutation(getWirelessGatewayTaskRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     * @return Result of the GetWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTaskDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskDefinitionResponse getWirelessGatewayTaskDefinition(
            GetWirelessGatewayTaskDefinitionRequest getWirelessGatewayTaskDefinitionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the GetWirelessGatewayTaskDefinition operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.GetWirelessGatewayTaskDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWirelessGatewayTaskDefinitionResponse getWirelessGatewayTaskDefinition(
            Consumer<GetWirelessGatewayTaskDefinitionRequest.Builder> getWirelessGatewayTaskDefinitionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return getWirelessGatewayTaskDefinition(GetWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(getWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return Result of the ListDestinations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsResponse listDestinations(ListDestinationsRequest listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return Result of the ListDestinations operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsResponse listDestinations(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listDestinations(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client
     *             .listDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsIterable listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client
     *             .listDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsIterable listDestinationsPaginator(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listDestinationsPaginator(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return Result of the ListDeviceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeviceProfilesResponse listDeviceProfiles(ListDeviceProfilesRequest listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeviceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeviceProfilesResponse listDeviceProfiles(Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listDeviceProfiles(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client
     *             .listDeviceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeviceProfilesIterable listDeviceProfilesPaginator(ListDeviceProfilesRequest listDeviceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client
     *             .listDeviceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesIterable responses = client.listDeviceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListDeviceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeviceProfilesIterable listDeviceProfilesPaginator(
            Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listDeviceProfilesPaginator(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     *
     * @param listPartnerAccountsRequest
     * @return Result of the ListPartnerAccounts operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPartnerAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPartnerAccountsResponse listPartnerAccounts(ListPartnerAccountsRequest listPartnerAccountsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPartnerAccountsRequest#builder()}
     * </p>
     *
     * @param listPartnerAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListPartnerAccountsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPartnerAccounts operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListPartnerAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPartnerAccountsResponse listPartnerAccounts(
            Consumer<ListPartnerAccountsRequest.Builder> listPartnerAccountsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listPartnerAccounts(ListPartnerAccountsRequest.builder().applyMutation(listPartnerAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return Result of the ListServiceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesResponse listServiceProfiles(ListServiceProfilesRequest listServiceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListServiceProfiles operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesResponse listServiceProfiles(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listServiceProfiles(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client
     *             .listServiceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesIterable listServiceProfilesPaginator(ListServiceProfilesRequest listServiceProfilesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client
     *             .listServiceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesIterable responses = client.listServiceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListServiceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesIterable listServiceProfilesPaginator(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listServiceProfilesPaginator(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return Result of the ListWirelessDevices operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesResponse listWirelessDevices(ListWirelessDevicesRequest listWirelessDevicesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return Result of the ListWirelessDevices operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesResponse listWirelessDevices(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessDevices(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client
     *             .listWirelessDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesIterable listWirelessDevicesPaginator(ListWirelessDevicesRequest listWirelessDevicesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client
     *             .listWirelessDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesIterable responses = client.listWirelessDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesIterable listWirelessDevicesPaginator(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessDevicesPaginator(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest)
                .build());
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     * @return Result of the ListWirelessGatewayTaskDefinitions operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewayTaskDefinitionsResponse listWirelessGatewayTaskDefinitions(
            ListWirelessGatewayTaskDefinitionsRequest listWirelessGatewayTaskDefinitionsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewayTaskDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListWirelessGatewayTaskDefinitionsRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewayTaskDefinitionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListWirelessGatewayTaskDefinitions operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewayTaskDefinitionsResponse listWirelessGatewayTaskDefinitions(
            Consumer<ListWirelessGatewayTaskDefinitionsRequest.Builder> listWirelessGatewayTaskDefinitionsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return listWirelessGatewayTaskDefinitions(ListWirelessGatewayTaskDefinitionsRequest.builder()
                .applyMutation(listWirelessGatewayTaskDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return Result of the ListWirelessGateways operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysResponse listWirelessGateways(ListWirelessGatewaysRequest listWirelessGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return Result of the ListWirelessGateways operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysResponse listWirelessGateways(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessGateways(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client
     *             .listWirelessGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysIterable listWirelessGatewaysPaginator(ListWirelessGatewaysRequest listWirelessGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client
     *             .listWirelessGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysIterable responses = client.listWirelessGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.ListWirelessGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysIterable listWirelessGatewaysPaginator(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return listWirelessGatewaysPaginator(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     * @return Result of the SendDataToWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.SendDataToWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataToWirelessDeviceResponse sendDataToWirelessDevice(
            SendDataToWirelessDeviceRequest sendDataToWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataToWirelessDeviceRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataToWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link SendDataToWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the SendDataToWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.SendDataToWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDataToWirelessDeviceResponse sendDataToWirelessDevice(
            Consumer<SendDataToWirelessDeviceRequest.Builder> sendDataToWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return sendDataToWirelessDevice(SendDataToWirelessDeviceRequest.builder().applyMutation(sendDataToWirelessDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws TooManyTagsException
     *         The request was denied because the resource can't have any more tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, TooManyTagsException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws TooManyTagsException
     *         The request was denied because the resource can't have any more tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, TooManyTagsException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     *
     * @param testWirelessDeviceRequest
     * @return Result of the TestWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TestWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default TestWirelessDeviceResponse testWirelessDevice(TestWirelessDeviceRequest testWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link TestWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param testWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link TestWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the TestWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.TestWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default TestWirelessDeviceResponse testWirelessDevice(Consumer<TestWirelessDeviceRequest.Builder> testWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotWirelessException {
        return testWirelessDevice(TestWirelessDeviceRequest.builder().applyMutation(testWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws ConflictException
     *         Adding, updating, or deleting the resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     *
     * @param updateDestinationRequest
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDestinationResponse updateDestination(UpdateDestinationRequest updateDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDestinationRequest#builder()}
     * </p>
     *
     * @param updateDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDestinationRequest.Builder} to create a request.
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDestinationResponse updateDestination(Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        return updateDestination(UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest).build());
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     *
     * @param updatePartnerAccountRequest
     * @return Result of the UpdatePartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdatePartnerAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePartnerAccountResponse updatePartnerAccount(UpdatePartnerAccountRequest updatePartnerAccountRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePartnerAccountRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePartnerAccountRequest#builder()}
     * </p>
     *
     * @param updatePartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePartnerAccountRequest.Builder} to create a
     *        request.
     * @return Result of the UpdatePartnerAccount operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdatePartnerAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePartnerAccountResponse updatePartnerAccount(
            Consumer<UpdatePartnerAccountRequest.Builder> updatePartnerAccountRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotWirelessException {
        return updatePartnerAccount(UpdatePartnerAccountRequest.builder().applyMutation(updatePartnerAccountRequest).build());
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     *
     * @param updateWirelessDeviceRequest
     * @return Result of the UpdateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessDeviceResponse updateWirelessDevice(UpdateWirelessDeviceRequest updateWirelessDeviceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param updateWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWirelessDevice operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessDeviceResponse updateWirelessDevice(
            Consumer<UpdateWirelessDeviceRequest.Builder> updateWirelessDeviceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return updateWirelessDevice(UpdateWirelessDeviceRequest.builder().applyMutation(updateWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     *
     * @param updateWirelessGatewayRequest
     * @return Result of the UpdateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessGatewayResponse updateWirelessGateway(UpdateWirelessGatewayRequest updateWirelessGatewayRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, IotWirelessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param updateWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWirelessGateway operation returned by the service.
     * @throws ValidationException
     *         The input did not meet the specified constraints.
     * @throws ResourceNotFoundException
     *         Resource does not exist.
     * @throws AccessDeniedException
     *         User does not have permission to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ThrottlingException
     *         The request was denied because it exceeded the allowed API request rate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotWirelessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotWirelessClient.UpdateWirelessGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWirelessGatewayResponse updateWirelessGateway(
            Consumer<UpdateWirelessGatewayRequest.Builder> updateWirelessGatewayRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotWirelessException {
        return updateWirelessGateway(UpdateWirelessGatewayRequest.builder().applyMutation(updateWirelessGatewayRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("api.iotwireless");
    }
}
