/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.WirelessMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendDataToWirelessDeviceRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, SendDataToWirelessDeviceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SendDataToWirelessDeviceRequest.getter(SendDataToWirelessDeviceRequest::id)).setter(SendDataToWirelessDeviceRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<Integer> TRANSMIT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransmitMode").getter(SendDataToWirelessDeviceRequest.getter(SendDataToWirelessDeviceRequest::transmitMode)).setter(SendDataToWirelessDeviceRequest.setter(Builder::transmitMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmitMode").build()}).build();
    private static final SdkField<String> PAYLOAD_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadData").getter(SendDataToWirelessDeviceRequest.getter(SendDataToWirelessDeviceRequest::payloadData)).setter(SendDataToWirelessDeviceRequest.setter(Builder::payloadData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadData").build()}).build();
    private static final SdkField<WirelessMetadata> WIRELESS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WirelessMetadata").getter(SendDataToWirelessDeviceRequest.getter(SendDataToWirelessDeviceRequest::wirelessMetadata)).setter(SendDataToWirelessDeviceRequest.setter(Builder::wirelessMetadata)).constructor(WirelessMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TRANSMIT_MODE_FIELD, PAYLOAD_DATA_FIELD, WIRELESS_METADATA_FIELD));
    private final String id;
    private final Integer transmitMode;
    private final String payloadData;
    private final WirelessMetadata wirelessMetadata;

    private SendDataToWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.transmitMode = builder.transmitMode;
        this.payloadData = builder.payloadData;
        this.wirelessMetadata = builder.wirelessMetadata;
    }

    public String id() {
        return this.id;
    }

    public Integer transmitMode() {
        return this.transmitMode;
    }

    public String payloadData() {
        return this.payloadData;
    }

    public WirelessMetadata wirelessMetadata() {
        return this.wirelessMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.transmitMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadData());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataToWirelessDeviceRequest)) {
            return false;
        }
        SendDataToWirelessDeviceRequest other = (SendDataToWirelessDeviceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.transmitMode(), other.transmitMode()) && Objects.equals(this.payloadData(), other.payloadData()) && Objects.equals(this.wirelessMetadata(), other.wirelessMetadata());
    }

    public String toString() {
        return ToString.builder((String)"SendDataToWirelessDeviceRequest").add("Id", (Object)this.id()).add("TransmitMode", (Object)this.transmitMode()).add("PayloadData", (Object)this.payloadData()).add("WirelessMetadata", (Object)this.wirelessMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "TransmitMode": {
                return Optional.ofNullable(clazz.cast(this.transmitMode()));
            }
            case "PayloadData": {
                return Optional.ofNullable(clazz.cast(this.payloadData()));
            }
            case "WirelessMetadata": {
                return Optional.ofNullable(clazz.cast(this.wirelessMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendDataToWirelessDeviceRequest, T> g) {
        return obj -> g.apply((SendDataToWirelessDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String id;
        private Integer transmitMode;
        private String payloadData;
        private WirelessMetadata wirelessMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataToWirelessDeviceRequest model) {
            super(model);
            this.id(model.id);
            this.transmitMode(model.transmitMode);
            this.payloadData(model.payloadData);
            this.wirelessMetadata(model.wirelessMetadata);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getTransmitMode() {
            return this.transmitMode;
        }

        @Override
        public final Builder transmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
            return this;
        }

        public final void setTransmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
        }

        public final String getPayloadData() {
            return this.payloadData;
        }

        @Override
        public final Builder payloadData(String payloadData) {
            this.payloadData = payloadData;
            return this;
        }

        public final void setPayloadData(String payloadData) {
            this.payloadData = payloadData;
        }

        public final WirelessMetadata.Builder getWirelessMetadata() {
            return this.wirelessMetadata != null ? this.wirelessMetadata.toBuilder() : null;
        }

        @Override
        public final Builder wirelessMetadata(WirelessMetadata wirelessMetadata) {
            this.wirelessMetadata = wirelessMetadata;
            return this;
        }

        public final void setWirelessMetadata(WirelessMetadata.BuilderImpl wirelessMetadata) {
            this.wirelessMetadata = wirelessMetadata != null ? wirelessMetadata.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDataToWirelessDeviceRequest build() {
            return new SendDataToWirelessDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendDataToWirelessDeviceRequest> {
        public Builder id(String var1);

        public Builder transmitMode(Integer var1);

        public Builder payloadData(String var1);

        public Builder wirelessMetadata(WirelessMetadata var1);

        default public Builder wirelessMetadata(Consumer<WirelessMetadata.Builder> wirelessMetadata) {
            return this.wirelessMetadata((WirelessMetadata)((WirelessMetadata.Builder)WirelessMetadata.builder().applyMutation(wirelessMetadata)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

