/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.PartnerType;
import software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateAccount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePartnerAccountRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, UpdatePartnerAccountRequest> {
    private static final SdkField<SidewalkUpdateAccount> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(UpdatePartnerAccountRequest.getter(UpdatePartnerAccountRequest::sidewalk)).setter(UpdatePartnerAccountRequest.setter(Builder::sidewalk)).constructor(SidewalkUpdateAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<String> PARTNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerAccountId").getter(UpdatePartnerAccountRequest.getter(UpdatePartnerAccountRequest::partnerAccountId)).setter(UpdatePartnerAccountRequest.setter(Builder::partnerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PartnerAccountId").build()}).build();
    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerType").getter(UpdatePartnerAccountRequest.getter(UpdatePartnerAccountRequest::partnerTypeAsString)).setter(UpdatePartnerAccountRequest.setter(Builder::partnerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partnerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD, PARTNER_ACCOUNT_ID_FIELD, PARTNER_TYPE_FIELD));
    private final SidewalkUpdateAccount sidewalk;
    private final String partnerAccountId;
    private final String partnerType;

    private UpdatePartnerAccountRequest(BuilderImpl builder) {
        super(builder);
        this.sidewalk = builder.sidewalk;
        this.partnerAccountId = builder.partnerAccountId;
        this.partnerType = builder.partnerType;
    }

    public SidewalkUpdateAccount sidewalk() {
        return this.sidewalk;
    }

    public String partnerAccountId() {
        return this.partnerAccountId;
    }

    public PartnerType partnerType() {
        return PartnerType.fromValue(this.partnerType);
    }

    public String partnerTypeAsString() {
        return this.partnerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartnerAccountRequest)) {
            return false;
        }
        UpdatePartnerAccountRequest other = (UpdatePartnerAccountRequest)((Object)obj);
        return Objects.equals(this.sidewalk(), other.sidewalk()) && Objects.equals(this.partnerAccountId(), other.partnerAccountId()) && Objects.equals(this.partnerTypeAsString(), other.partnerTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePartnerAccountRequest").add("Sidewalk", (Object)this.sidewalk()).add("PartnerAccountId", (Object)this.partnerAccountId()).add("PartnerType", (Object)this.partnerTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "PartnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.partnerAccountId()));
            }
            case "PartnerType": {
                return Optional.ofNullable(clazz.cast(this.partnerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePartnerAccountRequest, T> g) {
        return obj -> g.apply((UpdatePartnerAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private SidewalkUpdateAccount sidewalk;
        private String partnerAccountId;
        private String partnerType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePartnerAccountRequest model) {
            super(model);
            this.sidewalk(model.sidewalk);
            this.partnerAccountId(model.partnerAccountId);
            this.partnerType(model.partnerType);
        }

        public final SidewalkUpdateAccount.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkUpdateAccount sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final void setSidewalk(SidewalkUpdateAccount.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        public final String getPartnerAccountId() {
            return this.partnerAccountId;
        }

        @Override
        public final Builder partnerAccountId(String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
            return this;
        }

        public final void setPartnerAccountId(String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
        }

        public final String getPartnerType() {
            return this.partnerType;
        }

        @Override
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        public final Builder partnerType(PartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePartnerAccountRequest build() {
            return new UpdatePartnerAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePartnerAccountRequest> {
        public Builder sidewalk(SidewalkUpdateAccount var1);

        default public Builder sidewalk(Consumer<SidewalkUpdateAccount.Builder> sidewalk) {
            return this.sidewalk((SidewalkUpdateAccount)((SidewalkUpdateAccount.Builder)SidewalkUpdateAccount.builder().applyMutation(sidewalk)).build());
        }

        public Builder partnerAccountId(String var1);

        public Builder partnerType(String var1);

        public Builder partnerType(PartnerType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

