/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.Order;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderBy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderBy> {
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("order").getter(OrderBy.getter(OrderBy::orderAsString)).setter(OrderBy.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyName").getter(OrderBy.getter(OrderBy::propertyName)).setter(OrderBy.setter(Builder::propertyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_FIELD, PROPERTY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrderBy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String order;
    private final String propertyName;

    private OrderBy(BuilderImpl builder) {
        this.order = builder.order;
        this.propertyName = builder.propertyName;
    }

    public final Order order() {
        return Order.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return Objects.equals(this.orderAsString(), other.orderAsString()) && Objects.equals(this.propertyName(), other.propertyName());
    }

    public final String toString() {
        return ToString.builder((String)"OrderBy").add("Order", (Object)this.orderAsString()).add("PropertyName", (Object)this.propertyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
            case "propertyName": {
                return Optional.ofNullable(clazz.cast(this.propertyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("order", ORDER_FIELD);
        map.put("propertyName", PROPERTY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrderBy, T> g) {
        return obj -> g.apply((OrderBy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String order;
        private String propertyName;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderBy model) {
            this.order(model.order);
            this.propertyName(model.propertyName);
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final String getPropertyName() {
            return this.propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public OrderBy build() {
            return new OrderBy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderBy> {
        public Builder order(String var1);

        public Builder order(Order var1);

        public Builder propertyName(String var1);
    }
}

