/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.CompositeComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CompositeComponentTypesResponseCopier;
import software.amazon.awssdk.services.iottwinmaker.model.ExtendsFromCopier;
import software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse;
import software.amazon.awssdk.services.iottwinmaker.model.FunctionsResponseCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionsResponseCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupsResponseCopier;
import software.amazon.awssdk.services.iottwinmaker.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComponentTypeResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetComponentTypeResponse> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::workspaceId)).setter(GetComponentTypeResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final SdkField<Boolean> IS_SINGLETON_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSingleton").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::isSingleton)).setter(GetComponentTypeResponse.setter(Builder::isSingleton)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSingleton").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::componentTypeId)).setter(GetComponentTypeResponse.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::description)).setter(GetComponentTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, PropertyDefinitionResponse>> PROPERTY_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyDefinitions").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::propertyDefinitions)).setter(GetComponentTypeResponse.setter(Builder::propertyDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyDefinitions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyDefinitionResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXTENDS_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("extendsFrom").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::extendsFrom)).setter(GetComponentTypeResponse.setter(Builder::extendsFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FunctionResponse>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("functions").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::functions)).setter(GetComponentTypeResponse.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::creationDateTime)).setter(GetComponentTypeResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::updateDateTime)).setter(GetComponentTypeResponse.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::arn)).setter(GetComponentTypeResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> IS_ABSTRACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAbstract").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::isAbstract)).setter(GetComponentTypeResponse.setter(Builder::isAbstract)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAbstract").build()}).build();
    private static final SdkField<Boolean> IS_SCHEMA_INITIALIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSchemaInitialized").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::isSchemaInitialized)).setter(GetComponentTypeResponse.setter(Builder::isSchemaInitialized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSchemaInitialized").build()}).build();
    private static final SdkField<Status> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::status)).setter(GetComponentTypeResponse.setter(Builder::status)).constructor(Status::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, PropertyGroupResponse>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyGroups").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::propertyGroups)).setter(GetComponentTypeResponse.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyGroupResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSource").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::syncSource)).setter(GetComponentTypeResponse.setter(Builder::syncSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeName").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::componentTypeName)).setter(GetComponentTypeResponse.setter(Builder::componentTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeName").build()}).build();
    private static final SdkField<Map<String, CompositeComponentTypeResponse>> COMPOSITE_COMPONENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("compositeComponentTypes").getter(GetComponentTypeResponse.getter(GetComponentTypeResponse::compositeComponentTypes)).setter(GetComponentTypeResponse.setter(Builder::compositeComponentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponentTypes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositeComponentTypeResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, IS_SINGLETON_FIELD, COMPONENT_TYPE_ID_FIELD, DESCRIPTION_FIELD, PROPERTY_DEFINITIONS_FIELD, EXTENDS_FROM_FIELD, FUNCTIONS_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, ARN_FIELD, IS_ABSTRACT_FIELD, IS_SCHEMA_INITIALIZED_FIELD, STATUS_FIELD, PROPERTY_GROUPS_FIELD, SYNC_SOURCE_FIELD, COMPONENT_TYPE_NAME_FIELD, COMPOSITE_COMPONENT_TYPES_FIELD));
    private final String workspaceId;
    private final Boolean isSingleton;
    private final String componentTypeId;
    private final String description;
    private final Map<String, PropertyDefinitionResponse> propertyDefinitions;
    private final List<String> extendsFrom;
    private final Map<String, FunctionResponse> functions;
    private final Instant creationDateTime;
    private final Instant updateDateTime;
    private final String arn;
    private final Boolean isAbstract;
    private final Boolean isSchemaInitialized;
    private final Status status;
    private final Map<String, PropertyGroupResponse> propertyGroups;
    private final String syncSource;
    private final String componentTypeName;
    private final Map<String, CompositeComponentTypeResponse> compositeComponentTypes;

    private GetComponentTypeResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.isSingleton = builder.isSingleton;
        this.componentTypeId = builder.componentTypeId;
        this.description = builder.description;
        this.propertyDefinitions = builder.propertyDefinitions;
        this.extendsFrom = builder.extendsFrom;
        this.functions = builder.functions;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.arn = builder.arn;
        this.isAbstract = builder.isAbstract;
        this.isSchemaInitialized = builder.isSchemaInitialized;
        this.status = builder.status;
        this.propertyGroups = builder.propertyGroups;
        this.syncSource = builder.syncSource;
        this.componentTypeName = builder.componentTypeName;
        this.compositeComponentTypes = builder.compositeComponentTypes;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final Boolean isSingleton() {
        return this.isSingleton;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPropertyDefinitions() {
        return this.propertyDefinitions != null && !(this.propertyDefinitions instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyDefinitionResponse> propertyDefinitions() {
        return this.propertyDefinitions;
    }

    public final boolean hasExtendsFrom() {
        return this.extendsFrom != null && !(this.extendsFrom instanceof SdkAutoConstructList);
    }

    public final List<String> extendsFrom() {
        return this.extendsFrom;
    }

    public final boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructMap);
    }

    public final Map<String, FunctionResponse> functions() {
        return this.functions;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean isAbstract() {
        return this.isAbstract;
    }

    public final Boolean isSchemaInitialized() {
        return this.isSchemaInitialized;
    }

    public final Status status() {
        return this.status;
    }

    public final boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyGroupResponse> propertyGroups() {
        return this.propertyGroups;
    }

    public final String syncSource() {
        return this.syncSource;
    }

    public final String componentTypeName() {
        return this.componentTypeName;
    }

    public final boolean hasCompositeComponentTypes() {
        return this.compositeComponentTypes != null && !(this.compositeComponentTypes instanceof SdkAutoConstructMap);
    }

    public final Map<String, CompositeComponentTypeResponse> compositeComponentTypes() {
        return this.compositeComponentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSingleton());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyDefinitions() ? this.propertyDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendsFrom() ? this.extendsFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctions() ? this.functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAbstract());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSchemaInitialized());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroups() ? this.propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositeComponentTypes() ? this.compositeComponentTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentTypeResponse)) {
            return false;
        }
        GetComponentTypeResponse other = (GetComponentTypeResponse)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.isSingleton(), other.isSingleton()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.description(), other.description()) && this.hasPropertyDefinitions() == other.hasPropertyDefinitions() && Objects.equals(this.propertyDefinitions(), other.propertyDefinitions()) && this.hasExtendsFrom() == other.hasExtendsFrom() && Objects.equals(this.extendsFrom(), other.extendsFrom()) && this.hasFunctions() == other.hasFunctions() && Objects.equals(this.functions(), other.functions()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.isAbstract(), other.isAbstract()) && Objects.equals(this.isSchemaInitialized(), other.isSchemaInitialized()) && Objects.equals(this.status(), other.status()) && this.hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(this.propertyGroups(), other.propertyGroups()) && Objects.equals(this.syncSource(), other.syncSource()) && Objects.equals(this.componentTypeName(), other.componentTypeName()) && this.hasCompositeComponentTypes() == other.hasCompositeComponentTypes() && Objects.equals(this.compositeComponentTypes(), other.compositeComponentTypes());
    }

    public final String toString() {
        return ToString.builder((String)"GetComponentTypeResponse").add("WorkspaceId", (Object)this.workspaceId()).add("IsSingleton", (Object)this.isSingleton()).add("ComponentTypeId", (Object)this.componentTypeId()).add("Description", (Object)this.description()).add("PropertyDefinitions", this.hasPropertyDefinitions() ? this.propertyDefinitions() : null).add("ExtendsFrom", this.hasExtendsFrom() ? this.extendsFrom() : null).add("Functions", this.hasFunctions() ? this.functions() : null).add("CreationDateTime", (Object)this.creationDateTime()).add("UpdateDateTime", (Object)this.updateDateTime()).add("Arn", (Object)this.arn()).add("IsAbstract", (Object)this.isAbstract()).add("IsSchemaInitialized", (Object)this.isSchemaInitialized()).add("Status", (Object)this.status()).add("PropertyGroups", this.hasPropertyGroups() ? this.propertyGroups() : null).add("SyncSource", (Object)this.syncSource()).add("ComponentTypeName", (Object)this.componentTypeName()).add("CompositeComponentTypes", this.hasCompositeComponentTypes() ? this.compositeComponentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "isSingleton": {
                return Optional.ofNullable(clazz.cast(this.isSingleton()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "propertyDefinitions": {
                return Optional.ofNullable(clazz.cast(this.propertyDefinitions()));
            }
            case "extendsFrom": {
                return Optional.ofNullable(clazz.cast(this.extendsFrom()));
            }
            case "functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "isAbstract": {
                return Optional.ofNullable(clazz.cast(this.isAbstract()));
            }
            case "isSchemaInitialized": {
                return Optional.ofNullable(clazz.cast(this.isSchemaInitialized()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "propertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
            case "syncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
            case "componentTypeName": {
                return Optional.ofNullable(clazz.cast(this.componentTypeName()));
            }
            case "compositeComponentTypes": {
                return Optional.ofNullable(clazz.cast(this.compositeComponentTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentTypeResponse, T> g) {
        return obj -> g.apply((GetComponentTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String workspaceId;
        private Boolean isSingleton;
        private String componentTypeId;
        private String description;
        private Map<String, PropertyDefinitionResponse> propertyDefinitions = DefaultSdkAutoConstructMap.getInstance();
        private List<String> extendsFrom = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FunctionResponse> functions = DefaultSdkAutoConstructMap.getInstance();
        private Instant creationDateTime;
        private Instant updateDateTime;
        private String arn;
        private Boolean isAbstract;
        private Boolean isSchemaInitialized;
        private Status status;
        private Map<String, PropertyGroupResponse> propertyGroups = DefaultSdkAutoConstructMap.getInstance();
        private String syncSource;
        private String componentTypeName;
        private Map<String, CompositeComponentTypeResponse> compositeComponentTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentTypeResponse model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.isSingleton(model.isSingleton);
            this.componentTypeId(model.componentTypeId);
            this.description(model.description);
            this.propertyDefinitions(model.propertyDefinitions);
            this.extendsFrom(model.extendsFrom);
            this.functions(model.functions);
            this.creationDateTime(model.creationDateTime);
            this.updateDateTime(model.updateDateTime);
            this.arn(model.arn);
            this.isAbstract(model.isAbstract);
            this.isSchemaInitialized(model.isSchemaInitialized);
            this.status(model.status);
            this.propertyGroups(model.propertyGroups);
            this.syncSource(model.syncSource);
            this.componentTypeName(model.componentTypeName);
            this.compositeComponentTypes(model.compositeComponentTypes);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final Boolean getIsSingleton() {
            return this.isSingleton;
        }

        public final void setIsSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
        }

        @Override
        public final Builder isSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyDefinitionResponse.Builder> getPropertyDefinitions() {
            Map<String, PropertyDefinitionResponse.Builder> result = PropertyDefinitionsResponseCopier.copyToBuilder(this.propertyDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyDefinitions(Map<String, PropertyDefinitionResponse.BuilderImpl> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsResponseCopier.copyFromBuilder(propertyDefinitions);
        }

        @Override
        public final Builder propertyDefinitions(Map<String, PropertyDefinitionResponse> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsResponseCopier.copy(propertyDefinitions);
            return this;
        }

        public final Collection<String> getExtendsFrom() {
            if (this.extendsFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return this.extendsFrom;
        }

        public final void setExtendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
        }

        @Override
        public final Builder extendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendsFrom(String ... extendsFrom) {
            this.extendsFrom(Arrays.asList(extendsFrom));
            return this;
        }

        public final Map<String, FunctionResponse.Builder> getFunctions() {
            Map<String, FunctionResponse.Builder> result = FunctionsResponseCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Map<String, FunctionResponse.BuilderImpl> functions) {
            this.functions = FunctionsResponseCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Map<String, FunctionResponse> functions) {
            this.functions = FunctionsResponseCopier.copy(functions);
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getIsAbstract() {
            return this.isAbstract;
        }

        public final void setIsAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
        }

        @Override
        public final Builder isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public final Boolean getIsSchemaInitialized() {
            return this.isSchemaInitialized;
        }

        public final void setIsSchemaInitialized(Boolean isSchemaInitialized) {
            this.isSchemaInitialized = isSchemaInitialized;
        }

        @Override
        public final Builder isSchemaInitialized(Boolean isSchemaInitialized) {
            this.isSchemaInitialized = isSchemaInitialized;
            return this;
        }

        public final Status.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final Map<String, PropertyGroupResponse.Builder> getPropertyGroups() {
            Map<String, PropertyGroupResponse.Builder> result = PropertyGroupsResponseCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, PropertyGroupResponse.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsResponseCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, PropertyGroupResponse> propertyGroups) {
            this.propertyGroups = PropertyGroupsResponseCopier.copy(propertyGroups);
            return this;
        }

        public final String getSyncSource() {
            return this.syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getComponentTypeName() {
            return this.componentTypeName;
        }

        public final void setComponentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
        }

        @Override
        public final Builder componentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
            return this;
        }

        public final Map<String, CompositeComponentTypeResponse.Builder> getCompositeComponentTypes() {
            Map<String, CompositeComponentTypeResponse.Builder> result = CompositeComponentTypesResponseCopier.copyToBuilder(this.compositeComponentTypes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponentTypes(Map<String, CompositeComponentTypeResponse.BuilderImpl> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesResponseCopier.copyFromBuilder(compositeComponentTypes);
        }

        @Override
        public final Builder compositeComponentTypes(Map<String, CompositeComponentTypeResponse> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesResponseCopier.copy(compositeComponentTypes);
            return this;
        }

        @Override
        public GetComponentTypeResponse build() {
            return new GetComponentTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComponentTypeResponse> {
        public Builder workspaceId(String var1);

        public Builder isSingleton(Boolean var1);

        public Builder componentTypeId(String var1);

        public Builder description(String var1);

        public Builder propertyDefinitions(Map<String, PropertyDefinitionResponse> var1);

        public Builder extendsFrom(Collection<String> var1);

        public Builder extendsFrom(String ... var1);

        public Builder functions(Map<String, FunctionResponse> var1);

        public Builder creationDateTime(Instant var1);

        public Builder updateDateTime(Instant var1);

        public Builder arn(String var1);

        public Builder isAbstract(Boolean var1);

        public Builder isSchemaInitialized(Boolean var1);

        public Builder status(Status var1);

        default public Builder status(Consumer<Status.Builder> status) {
            return this.status((Status)((Status.Builder)Status.builder().applyMutation(status)).build());
        }

        public Builder propertyGroups(Map<String, PropertyGroupResponse> var1);

        public Builder syncSource(String var1);

        public Builder componentTypeName(String var1);

        public Builder compositeComponentTypes(Map<String, CompositeComponentTypeResponse> var1);
    }
}

