/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.RowDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Row
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Row> {
    private static final SdkField<List<Document>> ROW_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowData").getter(Row.getter(Row::rowData)).setter(Row.setter(Builder::rowData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("rowData", ROW_DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Document> rowData;

    private Row(BuilderImpl builder) {
        this.rowData = builder.rowData;
    }

    public final boolean hasRowData() {
        return this.rowData != null && !(this.rowData instanceof SdkAutoConstructList);
    }

    public final List<Document> rowData() {
        return this.rowData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowData() ? this.rowData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        return this.hasRowData() == other.hasRowData() && Objects.equals(this.rowData(), other.rowData());
    }

    public final String toString() {
        return ToString.builder((String)"Row").add("RowData", this.hasRowData() ? this.rowData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rowData": {
                return Optional.ofNullable(clazz.cast(this.rowData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Row, T> g) {
        return obj -> g.apply((Row)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Document> rowData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Row model) {
            this.rowData(model.rowData);
        }

        public final Collection<Document> getRowData() {
            if (this.rowData instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowData;
        }

        public final void setRowData(Collection<Document> rowData) {
            this.rowData = RowDataCopier.copy(rowData);
        }

        @Override
        public final Builder rowData(Collection<Document> rowData) {
            this.rowData = RowDataCopier.copy(rowData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowData(Document ... rowData) {
            this.rowData(Arrays.asList(rowData));
            return this;
        }

        public Row build() {
            return new Row(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Row> {
        public Builder rowData(Collection<Document> var1);

        public Builder rowData(Document ... var1);
    }
}

