/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyRequest> {
    private static final SdkField<PropertyDefinitionRequest> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(PropertyRequest.getter(PropertyRequest::definition)).setter(PropertyRequest.setter(Builder::definition)).constructor(PropertyDefinitionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<DataValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(PropertyRequest.getter(PropertyRequest::value)).setter(PropertyRequest.setter(Builder::value)).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(PropertyRequest.getter(PropertyRequest::updateTypeAsString)).setter(PropertyRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, VALUE_FIELD, UPDATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("definition", DEFINITION_FIELD);
            this.put("value", VALUE_FIELD);
            this.put("updateType", UPDATE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PropertyDefinitionRequest definition;
    private final DataValue value;
    private final String updateType;

    private PropertyRequest(BuilderImpl builder) {
        this.definition = builder.definition;
        this.value = builder.value;
        this.updateType = builder.updateType;
    }

    public final PropertyDefinitionRequest definition() {
        return this.definition;
    }

    public final DataValue value() {
        return this.value;
    }

    public final PropertyUpdateType updateType() {
        return PropertyUpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyRequest)) {
            return false;
        }
        PropertyRequest other = (PropertyRequest)obj;
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyRequest").add("Definition", (Object)this.definition()).add("Value", (Object)this.value()).add("UpdateType", (Object)this.updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PropertyRequest, T> g) {
        return obj -> g.apply((PropertyRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PropertyDefinitionRequest definition;
        private DataValue value;
        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyRequest model) {
            this.definition(model.definition);
            this.value(model.value);
            this.updateType(model.updateType);
        }

        public final PropertyDefinitionRequest.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(PropertyDefinitionRequest.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PropertyDefinitionRequest definition) {
            this.definition = definition;
            return this;
        }

        public final DataValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(DataValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataValue value) {
            this.value = value;
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(PropertyUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public PropertyRequest build() {
            return new PropertyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyRequest> {
        public Builder definition(PropertyDefinitionRequest var1);

        default public Builder definition(Consumer<PropertyDefinitionRequest.Builder> definition) {
            return this.definition((PropertyDefinitionRequest)((PropertyDefinitionRequest.Builder)PropertyDefinitionRequest.builder().applyMutation(definition)).build());
        }

        public Builder value(DataValue var1);

        default public Builder value(Consumer<DataValue.Builder> value) {
            return this.value((DataValue)((DataValue.Builder)DataValue.builder().applyMutation(value)).build());
        }

        public Builder updateType(String var1);

        public Builder updateType(PropertyUpdateType var1);
    }
}

